/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml.parser;

import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.parser.MXParserNonValidating;
import com.reandroid.xml.parser.XmlPullParser;
import com.reandroid.xml.parser.XmlPullParserException;
import java.io.IOException;
import java.io.StringReader;

public class XMLSpanParser {
    private final Object mLock = new Object();
    private final XmlPullParser mParser = new MXParserNonValidating();
    private XMLElement mCurrentElement;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement parse(String text) throws XMLException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                text = "<spannable-parser>" + text + "</spannable-parser>";
                this.parseString(text);
            }
            catch (XmlPullParserException | IOException ex) {
                throw new XMLException(ex.getMessage());
            }
            XMLElement element = this.mCurrentElement;
            this.mCurrentElement = null;
            return element;
        }
    }

    private void parseString(String text) throws XmlPullParserException, IOException {
        int type;
        this.mCurrentElement = null;
        StringReader reader = new StringReader(text);
        this.mParser.setInput(reader);
        while ((type = this.mParser.next()) != 1) {
            this.event(type);
        }
    }

    private void event(int type) {
        if (type == 0) {
            this.onStartDocument();
        } else if (type == 2) {
            this.onStartTag();
        } else if (type == 3) {
            this.onEndTag();
        } else if (type == 4) {
            this.onText();
        } else if (type == 6) {
            this.onEntityRef();
        } else if (type == 7) {
            this.onText();
        }
    }

    private void loadAttributes() {
        int max = this.mParser.getAttributeCount();
        for (int i = 0; i < max; ++i) {
            this.onAttribute(i);
        }
    }

    private void onAttribute(int i) {
        String attrName = this.mParser.getAttributeName(i);
        String attrValue = this.mParser.getAttributeValue(i);
        this.mCurrentElement.setAttribute(attrName, attrValue);
    }

    private void onStartTag() {
        String name = this.mParser.getName();
        this.mCurrentElement = this.mCurrentElement == null ? new XMLElement(name) : this.mCurrentElement.createElement(name);
        this.loadAttributes();
    }

    private void onEndTag() {
        XMLElement parent = this.mCurrentElement.getParent();
        if (parent != null) {
            this.mCurrentElement = parent;
        }
    }

    private void onText() {
        String text = this.mParser.getText();
        if (text != null && text.length() > 0) {
            this.mCurrentElement.addText(new XMLText(text));
        }
    }

    private void onEntityRef() {
        String text = this.getEntity(this.mParser.getName());
        this.mCurrentElement.addText(new XMLText(text));
    }

    private String getEntity(String name) {
        if ("amp".equals(name)) {
            return "&";
        }
        if ("lt".equals(name)) {
            return "<";
        }
        if ("gt".equals(name)) {
            return ">";
        }
        return name;
    }

    private void onStartDocument() {
        this.mCurrentElement = null;
    }
}

