/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml.parser;

import com.android.org.kxml2.io.KXmlParser;
import com.reandroid.common.FileChannelInputStream;
import com.reandroid.xml.NameSpaceItem;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLDocument;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.parser.MXParser;
import com.reandroid.xml.parser.XMLParseException;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLDocumentParser {
    private final XmlPullParser mParser;
    private XMLDocument mResDocument;
    private XMLElement mCurrentElement;
    private boolean mNameSpaceCreated;
    private StringBuilder mCurrentText;
    private List<XMLComment> mComments;
    private int mIndent;
    private static final int ANDROID_PACKAGE_MAX = 3;

    public XMLDocumentParser(XmlPullParser parser) {
        this.mParser = parser;
    }

    public XMLDocumentParser(InputStream in) throws XMLParseException {
        this(XMLDocumentParser.createParser(in));
    }

    public XMLDocumentParser(File file) throws XMLParseException {
        this(XMLDocumentParser.createParser(file));
    }

    public XMLDocumentParser(String text) throws XMLParseException {
        this(XMLDocumentParser.createParser(text));
    }

    public XMLDocument parse() throws XMLParseException {
        try {
            XMLDocument document = this.parseDocument();
            this.close();
            return document;
        }
        catch (IOException | XmlPullParserException e) {
            XMLParseException ex = new XMLParseException(e.getMessage());
            ex.setStackTrace(e.getStackTrace());
            throw ex;
        }
    }

    private void close() {
        this.closeParser();
        this.closeReader();
        this.closeFileInputStream();
        this.mResDocument = null;
        this.mCurrentElement = null;
        this.mCurrentText = null;
        this.mComments = null;
    }

    private void closeFileInputStream() {
        if (!(this.mParser instanceof MXParser)) {
            return;
        }
        MXParser parser = (MXParser)((Object)this.mParser);
        InputStream inputStream = parser.getInputStream();
        if (!(inputStream instanceof FileInputStream)) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeReader() {
        if (!(this.mParser instanceof MXParser)) {
            return;
        }
        MXParser parser = (MXParser)((Object)this.mParser);
        Reader reader = parser.getReader();
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void closeParser() {
        if (!(this.mParser instanceof Closeable)) {
            return;
        }
        Closeable closeable = (Closeable)((Object)this.mParser);
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private XMLDocument parseDocument() throws XmlPullParserException, IOException {
        int type;
        this.mResDocument = null;
        while ((type = this.mParser.nextToken()) != 1) {
            this.event(type);
        }
        this.event(1);
        if (this.mResDocument == null) {
            throw new XmlPullParserException("Failed to parse/empty document");
        }
        return this.mResDocument;
    }

    private void event(int type) {
        if (type == 0) {
            this.onStartDocument();
        } else if (type == 1) {
            this.onEndDocument();
        } else if (type == 2) {
            this.onStartTag();
        } else if (type == 3) {
            this.onEndTag();
        } else if (type == 4) {
            this.onText();
        } else if (type == 6) {
            this.onEntityRef();
        } else if (type == 9) {
            this.onComment();
        } else if (type == 7) {
            this.onIgnorableWhiteSpace();
        } else {
            this.onUnknownType(type);
        }
    }

    private void onStartDocument() {
        this.mResDocument = new XMLDocument();
        this.mIndent = -1;
    }

    private void onEndDocument() {
        this.flushComments(null);
        this.applyIndent(this.mResDocument);
    }

    private void onStartTag() {
        String prefix;
        String name = this.mParser.getName();
        this.flushTextContent();
        if (this.mCurrentElement == null) {
            if (this.mResDocument == null) {
                this.onStartDocument();
            }
            this.mCurrentElement = new XMLElement(name);
            this.mResDocument.setDocumentElement(this.mCurrentElement);
        } else {
            this.mCurrentElement = this.mCurrentElement.createElement(name);
        }
        this.mCurrentElement.setColumnNumber(this.mParser.getColumnNumber());
        this.mCurrentElement.setLineNumber(this.mParser.getLineNumber());
        this.checkIndent();
        this.flushComments(this.mCurrentElement);
        String ns = this.mParser.getNamespace();
        if (!XMLUtil.isEmpty(ns) && !XMLUtil.isEmpty(prefix = this.mParser.getPrefix())) {
            String tagName = this.appendPrefix(prefix, name);
            this.mCurrentElement.setTagName(tagName);
            this.checkNamespace(prefix, ns);
        }
        this.loadAttributes();
    }

    private void loadAttributes() {
        int max = this.mParser.getAttributeCount();
        for (int i = 0; i < max; ++i) {
            this.onAttribute(i);
        }
    }

    private void onAttribute(int i) {
        String attrName = this.mParser.getAttributeName(i);
        String attrValue = this.mParser.getAttributeValue(i);
        String prefix = this.mParser.getAttributePrefix(i);
        if (!XMLUtil.isEmpty(prefix)) {
            attrName = this.appendPrefix(prefix, attrName);
            this.checkNamespace(prefix, i);
        }
        this.mCurrentElement.setAttribute(attrName, attrValue);
    }

    private String appendPrefix(String prefix, String attrName) {
        if (!prefix.endsWith(":")) {
            prefix = prefix + ":";
        }
        if (!attrName.startsWith(prefix)) {
            attrName = prefix + attrName;
        }
        return attrName;
    }

    private void checkNamespace(String prefix, int i) {
        NameSpaceItem nsItem = this.mCurrentElement.getNameSpaceItemForPrefix(prefix);
        if (nsItem != null) {
            return;
        }
        String nsUri = null;
        try {
            nsUri = this.mParser.getNamespaceUri(i);
        }
        catch (XmlPullParserException xmlPullParserException) {
            // empty catch block
        }
        this.checkNamespace(prefix, nsUri);
    }

    private void checkNamespace(String prefix, String nsUri) {
        NameSpaceItem nsItem = this.mCurrentElement.getNameSpaceItemForPrefix(prefix);
        if (nsItem != null) {
            return;
        }
        nsItem = new NameSpaceItem(prefix, nsUri);
        this.mCurrentElement.addNameSpace(nsItem);
        this.mNameSpaceCreated = true;
    }

    private void onEndTag() {
        this.flushTextContent();
        if (this.mNameSpaceCreated) {
            this.mCurrentElement.applyNameSpaceItems();
            this.mNameSpaceCreated = false;
        }
        this.mCurrentElement = this.mCurrentElement.getParent();
    }

    private void onText() {
        String textContent = this.mParser.getText();
        this.appendText(textContent);
    }

    private void appendText(String text) {
        if (text == null) {
            return;
        }
        if (this.mCurrentText == null) {
            this.mCurrentText = new StringBuilder();
        }
        this.mCurrentText.append(text);
    }

    private void flushTextContent() {
        if (this.mCurrentText == null) {
            return;
        }
        String text = this.mCurrentText.toString();
        this.mCurrentText = null;
        if (text.trim().length() == 0 && !this.mCurrentElement.hasTextContent()) {
            return;
        }
        this.mCurrentElement.addText(new XMLText(text));
    }

    private void onEntityRef() {
        String name = this.mParser.getName();
        if (XMLUtil.isEmpty(name)) {
            return;
        }
        this.appendText("&");
        this.appendText(name);
        this.appendText(";");
    }

    private void onComment() {
        String commentText = this.mParser.getText();
        this.addComment(commentText);
    }

    private void addComment(String commentText) {
        if (XMLUtil.isEmpty(commentText)) {
            return;
        }
        XMLComment commentElement = new XMLComment();
        commentElement.setCommentText(commentText);
        commentElement.setColumnNumber(this.mParser.getColumnNumber());
        commentElement.setLineNumber(this.mParser.getLineNumber());
        this.addComment(commentElement);
    }

    private void addComment(XMLComment ce) {
        if (ce == null) {
            return;
        }
        if (this.mComments == null) {
            this.mComments = new ArrayList<XMLComment>();
        }
        this.mComments.add(ce);
    }

    private void flushComments(XMLElement element) {
        if (this.mComments == null) {
            return;
        }
        if (element != null) {
            element.addComments(this.mComments);
        }
        this.mComments.clear();
        this.mComments = null;
    }

    private void onIgnorableWhiteSpace() {
    }

    private void onIgnore(int type) {
    }

    private void onUnknownType(int type) {
        String typeName = this.toTypeName(type);
    }

    private String toTypeName(int type) {
        String[] allTypes = XmlPullParser.TYPES;
        if (type < 0 || type >= allTypes.length) {
            return "type:" + type;
        }
        return allTypes[type];
    }

    private void checkIndent() {
        if (this.mIndent >= 0) {
            return;
        }
        String txt = this.mParser.getText();
        if (txt == null) {
            return;
        }
        int len = txt.length();
        int col = this.mParser.getColumnNumber();
        this.mIndent = col - len;
        if (this.mIndent < 0) {
            this.mIndent = 0;
        }
    }

    private void applyIndent(XMLDocument resDocument) {
        if (this.mIndent <= 0 || this.mIndent > 5 || resDocument == null) {
            this.mIndent = -1;
            return;
        }
        resDocument.setIndent(this.mIndent);
        this.mIndent = -1;
    }

    private static XmlPullParser createParser(String text) throws XMLParseException {
        if (text == null) {
            throw new XMLParseException("Text is null, failed to create XmlPullParser");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        return XMLDocumentParser.createParser(in);
    }

    private static XmlPullParser createParser(File file) throws XMLParseException {
        if (file == null) {
            throw new XMLParseException("File is null, failed to create XmlPullParser");
        }
        if (!file.isFile()) {
            throw new XMLParseException("No such file : " + file.getAbsolutePath());
        }
        try {
            FileChannelInputStream in = new FileChannelInputStream(file);
            return XMLDocumentParser.createParser(in);
        }
        catch (IOException e) {
            throw new XMLParseException(e.getMessage());
        }
    }

    private static XmlPullParser createParser(InputStream in) throws XMLParseException {
        try {
            KXmlParser parser = new KXmlParser();
            parser.setInput(in, null);
            return parser;
        }
        catch (XmlPullParserException e) {
            throw new XMLParseException(e.getMessage());
        }
    }

    private static boolean isAndroid(int id) {
        int pkgId = XMLDocumentParser.toPackageId(id);
        return pkgId > 0 && pkgId <= 3;
    }

    private static boolean isResourceId(int id) {
        int pkgId = XMLDocumentParser.toPackageId(id);
        return pkgId > 0 && pkgId < 128;
    }

    private static int toPackageId(int id) {
        if (id <= 255) {
            return id;
        }
        return id >> 24 & 0xFF;
    }
}

