/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;
import java.io.IOException;
import java.io.Writer;

public class XmlHeaderElement
extends XMLElement {
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_ENCODING = "encoding";
    private static final String ATTR_STANDALONE = "standalone";

    public XmlHeaderElement(XmlHeaderElement element) {
        this();
        this.copyAll(element);
    }

    public XmlHeaderElement() {
        this.initializeStartEnd();
        this.setDefaultAttr();
    }

    private void copyAll(XmlHeaderElement element) {
        if (element == null) {
            return;
        }
        for (XMLAttribute exist : element.listAttributes()) {
            this.setAttribute(exist.getName(), exist.getValue());
        }
    }

    private void initializeStartEnd() {
        this.setTagName("xml");
        this.setStart("<?");
        this.setEnd("?>");
        this.setStartPrefix("");
        this.setEndPrefix("");
    }

    private void setDefaultAttr() {
        this.setVersion("1.0");
        this.setEncoding("utf-8");
        this.setStandalone(null);
    }

    public Object getProperty(String name) {
        XMLAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return null;
        }
        String val = attr.getValue();
        if (ATTR_STANDALONE.equalsIgnoreCase(name)) {
            boolean res = false;
            if ("true".equals(val)) {
                res = true;
            }
            return res;
        }
        return val;
    }

    public void setProperty(String name, Object o) {
        if (ATTR_STANDALONE.equalsIgnoreCase(name) && o instanceof Boolean) {
            this.setStandalone((Boolean)o);
            return;
        }
        String val = null;
        if (o != null) {
            val = o.toString();
        }
        this.setAttribute(name, val);
    }

    public void setVersion(String version) {
        this.setAttribute(ATTR_VERSION, version);
    }

    public void setEncoding(String encoding) {
        this.setAttribute(ATTR_ENCODING, encoding);
    }

    public void setStandalone(Boolean flag) {
        if (flag == null) {
            this.removeAttribute(ATTR_STANDALONE);
            return;
        }
        String str = flag != false ? "yes" : "no";
        this.setAttribute(ATTR_STANDALONE, str);
    }

    @Override
    int getChildIndent() {
        return 0;
    }

    @Override
    int getIndent() {
        return 0;
    }

    @Override
    void buildTextContent(Writer writer, boolean unEscape) throws IOException {
    }
}

