/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.Writer;

public class XMLText
extends XMLNode {
    private String text;

    public XMLText(String text) {
        this.text = XMLUtil.escapeXmlChars(text);
    }

    public XMLText() {
        this(null);
    }

    @Override
    public void addChildNode(XMLNode xmlNode) {
        throw new IllegalArgumentException("Can not add xml node on text: " + xmlNode);
    }

    public String getText() {
        return this.getText(true);
    }

    public String getText(boolean unEscape) {
        if (unEscape) {
            return XMLUtil.unEscapeXmlChars(this.text);
        }
        return this.text;
    }

    public void setText(String text) {
        this.text = XMLUtil.escapeXmlChars(text);
    }

    @Override
    void buildTextContent(Writer writer, boolean unEscape) throws IOException {
        writer.write(this.getText(unEscape));
    }

    @Override
    public boolean write(Writer writer, boolean newLineAttributes) throws IOException {
        if (!XMLUtil.isEmpty(this.text)) {
            writer.write(this.text);
            return true;
        }
        return false;
    }

    @Override
    public String toText(int indent, boolean newLineAttributes) {
        return this.getText(false);
    }

    public String toString() {
        return this.getText();
    }
}

