/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLSpanInfo;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.parser.XMLSpanParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XMLSpannable
implements Comparable<XMLSpannable> {
    private XMLElement mElement;
    private String mText;
    private List<XMLSpanInfo> mSpanInfoList;
    private static final XMLSpanParser PARSER = new XMLSpanParser();

    public XMLSpannable(XMLElement element) {
        this.mElement = element;
    }

    public boolean isValid() {
        List<XMLSpanInfo> spanInfoList = this.getSpanInfoList();
        if (spanInfoList.size() == 0) {
            return false;
        }
        for (XMLSpanInfo spanInfo : spanInfoList) {
            if (spanInfo.end >= spanInfo.start) continue;
            return false;
        }
        return true;
    }

    public String getXml() {
        StringBuilder builder = new StringBuilder();
        for (XMLNode xmlNode : this.mElement.getChildNodes()) {
            if (xmlNode instanceof XMLElement) {
                this.appendXml(builder, (XMLElement)xmlNode);
                continue;
            }
            if (!(xmlNode instanceof XMLText)) continue;
            this.appendXml(builder, (XMLText)xmlNode);
        }
        return builder.toString();
    }

    private void appendXml(StringBuilder builder, XMLElement element) {
        builder.append('<');
        builder.append(element.getTagName());
        this.appendXmlAttributes(builder, element);
        builder.append('>');
        for (XMLNode xmlNode : element.getChildNodes()) {
            if (xmlNode instanceof XMLElement) {
                this.appendXml(builder, (XMLElement)xmlNode);
                continue;
            }
            if (!(xmlNode instanceof XMLText)) continue;
            this.appendXml(builder, (XMLText)xmlNode);
        }
        builder.append('<');
        builder.append('/');
        builder.append(element.getTagName());
        builder.append('>');
    }

    private void appendXmlAttributes(StringBuilder builder, XMLElement element) {
        for (XMLAttribute xmlAttribute : element.listAttributes()) {
            builder.append(' ');
            builder.append(xmlAttribute.getName());
            builder.append('=');
            builder.append('\"');
            builder.append(xmlAttribute.getValue());
            builder.append('\"');
        }
    }

    private void appendXml(StringBuilder builder, XMLText xmlText) {
        builder.append(xmlText.getText(true));
    }

    public String getText() {
        if (this.mText == null) {
            this.buildSpanInfo();
        }
        return this.mText;
    }

    public List<XMLSpanInfo> getSpanInfoList() {
        if (this.mSpanInfoList == null) {
            this.buildSpanInfo();
        }
        return this.mSpanInfoList;
    }

    private void buildSpanInfo() {
        this.mSpanInfoList = new ArrayList<XMLSpanInfo>();
        StringBuilder builder = new StringBuilder();
        this.buildSpanInfo(this.mElement, builder);
        this.mText = builder.toString();
        this.mElement = null;
    }

    private void buildSpanInfo(XMLElement element, StringBuilder builder) {
        XMLSpanInfo info = null;
        for (XMLNode node : element.listSpannable()) {
            if (info != null) {
                int pos = builder.length();
                if (pos > 0) {
                    // empty if block
                }
                info.end = --pos;
                info = null;
            }
            if (node instanceof XMLText) {
                builder.append(((XMLText)node).getText());
                continue;
            }
            XMLElement child = (XMLElement)node;
            info = new XMLSpanInfo(child.getSpannableText(), builder.length(), 0);
            this.mSpanInfoList.add(info);
            this.buildSpanInfo(child, builder);
        }
        if (info != null) {
            int pos = builder.length();
            if (pos > 0) {
                --pos;
            }
            info.end = pos;
        }
    }

    @Override
    public int compareTo(XMLSpannable xmlSpannable) {
        return this.getText().compareTo(xmlSpannable.getText());
    }

    public static XMLSpannable parse(String text) {
        if (!XMLSpannable.hasStyle(text)) {
            return null;
        }
        try {
            XMLSpannable spannable = new XMLSpannable(PARSER.parse(text));
            if (spannable.isValid()) {
                return spannable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Set<String> tagList(Collection<XMLSpannable> spannableList) {
        HashSet<String> results = new HashSet<String>();
        for (XMLSpannable xmlSpannable : spannableList) {
            for (XMLSpanInfo spanInfo : xmlSpannable.getSpanInfoList()) {
                results.add(spanInfo.tag);
            }
        }
        return results;
    }

    public static List<String> toTextList(Collection<XMLSpannable> spannableList) {
        ArrayList<String> results = new ArrayList<String>(spannableList.size());
        for (XMLSpannable xmlSpannable : spannableList) {
            results.add(xmlSpannable.getText());
        }
        return results;
    }

    public static void sort(List<XMLSpannable> spannableList) {
        Comparator<XMLSpannable> cmp = new Comparator<XMLSpannable>(){

            @Override
            public int compare(XMLSpannable s1, XMLSpannable s2) {
                return s1.compareTo(s2);
            }
        };
        spannableList.sort(cmp);
    }

    private static boolean hasStyle(String text) {
        if (text == null) {
            return false;
        }
        int i = text.indexOf(60);
        if (i < 0) {
            return false;
        }
        i = text.indexOf(62);
        return i > 1;
    }
}

