/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.android.org.kxml2.io.KXmlParser;
import com.reandroid.common.FileChannelInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XMLParserFactory {
    public static XmlPullParser newPullParser(File file) throws XmlPullParserException {
        XmlPullParser parser = XMLParserFactory.newPullParser();
        try {
            parser.setInput(new FileChannelInputStream(file), StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            throw new XmlPullParserException(ex.getMessage() + ", file = " + file);
        }
        return parser;
    }

    public static XmlPullParser newPullParser(InputStream inputStream) throws XmlPullParserException {
        XmlPullParser parser = XMLParserFactory.newPullParser();
        parser.setInput(inputStream, StandardCharsets.UTF_8.name());
        return parser;
    }

    public static XmlPullParser newPullParser() {
        return new KXmlParser();
    }
}

