/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class XMLNode {
    private int mLineNumber;
    private int mColumnNumber;
    private final List<XMLNode> mChildNodes = new ArrayList<XMLNode>();

    public int getColumnNumber() {
        return this.mColumnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.mColumnNumber = columnNumber;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.mLineNumber = lineNumber;
    }

    public void addChildNode(XMLNode xmlNode) {
        boolean addOk = this.addChildNodeInternal(xmlNode);
        if (addOk) {
            this.onChildAdded(xmlNode);
        }
    }

    boolean addChildNodeInternal(XMLNode xmlNode) {
        if (xmlNode != null && this.canAdd(xmlNode)) {
            return this.mChildNodes.add(xmlNode);
        }
        return false;
    }

    void onChildAdded(XMLNode xmlNode) {
    }

    boolean canAdd(XMLNode xmlNode) {
        return xmlNode != null;
    }

    boolean contains(XMLNode xmlNode) {
        return this.mChildNodes.contains(xmlNode);
    }

    void removeChildNode(XMLNode xmlNode) {
        int i = this.mChildNodes.indexOf(xmlNode);
        while (i >= 0) {
            i = this.mChildNodes.indexOf(xmlNode);
        }
        this.mChildNodes.remove(xmlNode);
    }

    public void clearChildNodes() {
        this.clearChildNodesInternal();
    }

    void clearChildNodesInternal() {
        this.mChildNodes.clear();
    }

    public List<XMLNode> getChildNodes() {
        return this.mChildNodes;
    }

    boolean hasChildNodes() {
        return this.mChildNodes.size() > 0;
    }

    void buildTextContent(Writer writer, boolean unEscape) throws IOException {
    }

    public boolean write(Writer writer) throws IOException {
        return this.write(writer, false);
    }

    public String toText() {
        return this.toText(1, false);
    }

    public String toText(boolean newLineAttributes) {
        return this.toText(1, newLineAttributes);
    }

    public abstract boolean write(Writer var1, boolean var2) throws IOException;

    public abstract String toText(int var1, boolean var2);
}

