/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.ElementWriter;
import com.reandroid.xml.NameSpaceItem;
import com.reandroid.xml.SchemaAttr;
import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLComment;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLText;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.parser.XMLSpanParser;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class XMLElement
extends XMLNode {
    static final long DEBUG_TO_STRING = 500L;
    private String mTagName;
    private final LinkedHashMap<String, XMLAttribute> mAttributes = new LinkedHashMap();
    private final List<XMLElement> mChildElements = new ArrayList<XMLElement>();
    private final List<XMLComment> mComments = new ArrayList<XMLComment>();
    private final List<XMLText> mTexts = new ArrayList<XMLText>();
    private XMLElement mParent;
    private int mIndent;
    private float mAttributeIndentScale = 1.0f;
    private Object mTag;
    private int mResId;
    private float mIndentScale;
    private String mStart;
    private String mStartPrefix;
    private String mEnd;
    private String mEndPrefix;
    private Set<NameSpaceItem> nameSpaceItems;
    private static final int MAX_ATTRIBUTE_INDENT = 20;

    public XMLElement(String tagName) {
        this();
        this.setTagName(tagName);
    }

    public XMLElement() {
        this.setDefaultStartEnd();
    }

    public void addText(XMLText text) {
        this.addTextInternal(text, true);
    }

    private void addTextInternal(XMLText text, boolean addSupper) {
        if (text == null) {
            return;
        }
        this.mTexts.add(text);
        if (addSupper) {
            super.addChildNodeInternal(text);
        }
    }

    private void appendText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        this.addText(new XMLText(text));
    }

    public String getTagNamePrefix() {
        int i = this.mTagName.indexOf(":");
        if (i > 0) {
            return this.mTagName.substring(0, i);
        }
        return null;
    }

    public String getTagNameWoPrefix() {
        int i = this.mTagName.indexOf(":");
        if (i > 0) {
            return this.mTagName.substring(i + 1);
        }
        return this.mTagName;
    }

    private void setDefaultStartEnd() {
        this.mStart = "<";
        this.mEnd = ">";
        this.mStartPrefix = "/";
        this.mEndPrefix = "/";
    }

    public void applyNameSpaceItems() {
        if (this.nameSpaceItems != null) {
            for (NameSpaceItem nsItem : this.nameSpaceItems) {
                SchemaAttr schemaAttr = nsItem.toSchemaAttribute();
                XMLAttribute exist = this.getAttribute(schemaAttr.getName());
                if (exist != null) {
                    exist.setValue(schemaAttr.getValue());
                    continue;
                }
                this.addAttribute(schemaAttr);
            }
        }
        if (this.mParent != null) {
            this.mParent.applyNameSpaceItems();
        }
    }

    public void addNameSpace(NameSpaceItem nsItem) {
        if (nsItem == null) {
            return;
        }
        if (this.mParent != null) {
            this.mParent.addNameSpace(nsItem);
            return;
        }
        if (this.nameSpaceItems == null) {
            this.nameSpaceItems = new HashSet<NameSpaceItem>();
        }
        this.nameSpaceItems.add(nsItem);
    }

    public NameSpaceItem getNameSpaceItemForUri(String uri) {
        if (this.nameSpaceItems != null) {
            for (NameSpaceItem ns : this.nameSpaceItems) {
                if (!ns.isUriEqual(uri)) continue;
                return ns;
            }
        }
        if (this.mParent != null) {
            return this.mParent.getNameSpaceItemForUri(uri);
        }
        return null;
    }

    public NameSpaceItem getNameSpaceItemForPrefix(String prefix) {
        if (this.nameSpaceItems != null) {
            for (NameSpaceItem ns : this.nameSpaceItems) {
                if (!ns.isPrefixEqual(prefix)) continue;
                return ns;
            }
        }
        if (this.mParent != null) {
            return this.mParent.getNameSpaceItemForPrefix(prefix);
        }
        return null;
    }

    void setStart(String start) {
        this.mStart = start;
    }

    void setEnd(String end) {
        this.mEnd = end;
    }

    void setStartPrefix(String pfx) {
        if (pfx == null) {
            pfx = "";
        }
        this.mStartPrefix = pfx;
    }

    void setEndPrefix(String pfx) {
        if (pfx == null) {
            pfx = "";
        }
        this.mEndPrefix = pfx;
    }

    public void setIndentScale(float scale) {
        this.mIndentScale = scale;
    }

    private float getIndentScale() {
        XMLElement parent = this.getParent();
        if (parent == null) {
            return this.mIndentScale;
        }
        return parent.getIndentScale();
    }

    public int getResourceId() {
        return this.mResId;
    }

    public void setResourceId(int id) {
        this.mResId = id;
    }

    public XMLElement createElement(String tag) {
        XMLElement baseElement = new XMLElement(tag);
        this.addChildNoCheck(baseElement, true);
        return baseElement;
    }

    public void addChild(Collection<XMLElement> elements) {
        if (elements == null) {
            return;
        }
        for (XMLElement element : elements) {
            this.addChild(element);
        }
    }

    public void addChild(XMLElement child) {
        this.addChildNoCheck(child, true);
    }

    private void clearChildElements() {
        this.mChildElements.clear();
    }

    private void clearTexts() {
        this.mTexts.clear();
    }

    public XMLComment getCommentAt(int index) {
        if (index < 0) {
            return null;
        }
        if (index >= this.mComments.size()) {
            return null;
        }
        return this.mComments.get(index);
    }

    public void hideComments(boolean recursive, boolean hide) {
        this.hideComments(hide);
        if (recursive) {
            for (XMLElement child : this.mChildElements) {
                child.hideComments(recursive, hide);
            }
        }
    }

    private void hideComments(boolean hide) {
        for (XMLComment ce : this.mComments) {
            ce.setHidden(hide);
        }
    }

    public int getCommentsCount() {
        return this.mComments.size();
    }

    public void addComments(Collection<XMLComment> commentElements) {
        if (commentElements == null) {
            return;
        }
        for (XMLComment ce : commentElements) {
            this.addComment(ce);
        }
    }

    public void clearComments() {
        this.mComments.clear();
    }

    public void addComment(XMLComment commentElement) {
        this.addCommentInternal(commentElement, true);
    }

    void addCommentInternal(XMLComment commentElement, boolean addSuper) {
        if (commentElement == null) {
            return;
        }
        this.mComments.add(commentElement);
        commentElement.setIndent(this.getIndent());
        commentElement.setParent(this);
        if (addSuper) {
            super.addChildNodeInternal(commentElement);
        }
    }

    @Override
    void clearChildNodesInternal() {
        super.clearChildNodesInternal();
        this.mChildElements.clear();
        this.mComments.clear();
        this.mTexts.clear();
    }

    public Collection<XMLAttribute> listAttributes() {
        return this.mAttributes.values();
    }

    public int getChildesCount() {
        return this.mChildElements.size();
    }

    public List<XMLElement> listChildElements() {
        return this.mChildElements;
    }

    public XMLElement getChildAt(int index) {
        if (index < 0 || index >= this.mChildElements.size()) {
            return null;
        }
        return this.mChildElements.get(index);
    }

    public int getAttributeCount() {
        return this.mAttributes.size();
    }

    public String getAttributeValue(String name) {
        XMLAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    public int getAttributeValueInt(String name, int def) {
        XMLAttribute attr = this.getAttribute(name);
        if (attr == null) {
            return def;
        }
        return attr.getValueInt();
    }

    public int getAttributeValueInt(String name) throws XMLException {
        XMLAttribute attr = this.getAttribute(name);
        if (attr == null) {
            throw new XMLException("Expecting integer for attr <" + name + "> at '" + this.toString() + "'");
        }
        try {
            return attr.getValueInt();
        }
        catch (NumberFormatException ex) {
            throw new XMLException(ex.getMessage() + ":  '" + this.toString() + "'");
        }
    }

    public XMLAttribute getAttribute(String name) {
        return this.mAttributes.get(name);
    }

    public XMLAttribute removeAttribute(String name) {
        XMLAttribute attribute = (XMLAttribute)this.mAttributes.remove(name);
        if (attribute != null) {
            attribute.setParent(null);
        }
        return attribute;
    }

    public XMLAttribute setAttribute(String name, int value) {
        return this.setAttribute(name, String.valueOf(value));
    }

    public XMLAttribute setAttribute(String name, boolean value) {
        String v = value ? "true" : "false";
        return this.setAttribute(name, v);
    }

    public XMLAttribute setAttribute(String name, String value) {
        if (XMLUtil.isEmpty(name)) {
            return null;
        }
        XMLAttribute attr = this.getAttribute(name);
        if (attr == null) {
            attr = SchemaAttr.looksSchema(name, value) ? new SchemaAttr(name, value) : new XMLAttribute(name, value);
            this.addAttribute(attr);
        } else {
            attr.setValue(value);
        }
        return attr;
    }

    public void addAttributes(Collection<XMLAttribute> attrs) {
        if (attrs == null) {
            return;
        }
        for (XMLAttribute a : attrs) {
            this.addAttribute(a);
        }
    }

    public void addAttribute(XMLAttribute attr) {
        if (attr == null) {
            return;
        }
        String name = attr.getName();
        if (XMLUtil.isEmpty(name)) {
            return;
        }
        XMLAttribute exist = this.mAttributes.get(name);
        if (exist != null) {
            return;
        }
        this.mAttributes.put(name, attr);
        attr.setParent(this);
    }

    public void sortChildes(Comparator<XMLElement> comparator) {
        if (comparator == null) {
            return;
        }
        this.mChildElements.sort(comparator);
    }

    public XMLElement getParent() {
        return this.mParent;
    }

    void setParent(XMLElement baseElement) {
        this.mParent = baseElement;
    }

    @Override
    void onChildAdded(XMLNode xmlNode) {
        if (xmlNode instanceof XMLComment) {
            this.addCommentInternal((XMLComment)xmlNode, false);
        } else if (xmlNode instanceof XMLElement) {
            this.addChildNoCheck((XMLElement)xmlNode, false);
        } else if (xmlNode instanceof XMLText) {
            this.addTextInternal((XMLText)xmlNode, false);
        }
    }

    private void addChildNoCheck(XMLElement child, boolean addSupper) {
        if (child == null || child == this) {
            return;
        }
        child.setParent(this);
        child.setIndent(this.getChildIndent());
        this.mChildElements.add(child);
        if (addSupper) {
            super.addChildNodeInternal(child);
        }
    }

    public int getLevel() {
        int rs = 0;
        XMLElement parent = this.getParent();
        if (parent != null) {
            ++rs;
            rs += parent.getLevel();
        }
        return rs;
    }

    int getIndent() {
        XMLElement parent = this.getParent();
        if (parent != null && parent.hasTextContent()) {
            return 0;
        }
        return this.mIndent;
    }

    int getChildIndent() {
        if (this.mIndent <= 0 || this.hasTextContent()) {
            return 0;
        }
        int rs = this.mIndent + 1;
        String tag = this.getTagName();
        if (tag != null) {
            int i = tag.length();
            if (i > 10) {
                i = 10;
            }
            rs += i;
        }
        return rs;
    }

    public void setIndent(int indent) {
        this.mIndent = indent;
        int chIndent = this.getChildIndent();
        for (XMLElement child : this.mChildElements) {
            child.setIndent(chIndent);
        }
        if (this.mComments != null) {
            for (XMLComment ce : this.mComments) {
                ce.setIndent(indent);
            }
        }
    }

    public void setAttributesIndentScale(float indentScale) {
        this.setAttributesIndentScale(indentScale, true);
    }

    public void setAttributesIndentScale(float indentScale, boolean setToChildes) {
        this.mAttributeIndentScale = indentScale;
        if (!setToChildes) {
            return;
        }
        for (XMLElement child : this.listChildElements()) {
            child.setAttributesIndentScale(indentScale, true);
        }
    }

    private float getAttributeIndentScale() {
        return this.mAttributeIndentScale;
    }

    private int calculateAttributesIndent() {
        float scale = this.getAttributeIndentScale();
        int indent = 0;
        String tagName = this.getTagName();
        if (tagName != null) {
            indent += tagName.length();
        }
        if ((indent += 2) > 20) {
            indent = 20;
        }
        int baseIndent = this.getIndentWidth();
        indent = (int)(scale * (float)indent);
        if ((indent = baseIndent + indent) < 0) {
            indent = 0;
        }
        return indent;
    }

    private boolean appendAttributesIndentText(Writer writer, boolean appendOnce, int indent) throws IOException {
        if (indent <= 0) {
            return false;
        }
        if (appendOnce) {
            writer.write(XMLUtil.NEW_LINE);
            for (int i = 0; i < indent; ++i) {
                writer.write(32);
            }
        }
        return true;
    }

    boolean appendIndentText(Writer writer) throws IOException {
        int max = this.getIndentWidth();
        for (int i = 0; i < max; ++i) {
            writer.write(32);
        }
        return true;
    }

    private int getIndentWidth() {
        float scale = this.getIndentScale();
        int i = (int)(scale *= (float)this.getIndent());
        if (i <= 0) {
            i = 0;
        }
        if (i > 40) {
            i = 40;
        }
        return i;
    }

    public String getTagName() {
        return this.mTagName;
    }

    public void setTagName(String tag) {
        this.mTagName = tag;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object tag) {
        this.mTag = tag;
    }

    public String getTextContent() {
        if (!this.hasTextContent()) {
            return null;
        }
        return this.buildTextContent(true);
    }

    public String buildTextContent(boolean unEscape) {
        StringWriter writer = new StringWriter();
        try {
            for (XMLNode node : this.getChildNodes()) {
                node.buildTextContent(writer, unEscape);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    void buildTextContent(Writer writer, boolean unEscape) throws IOException {
        writer.write("<");
        writer.write(this.getTagName());
        this.appendAttributes(writer, false);
        if (!this.hasChildNodes()) {
            writer.write("/>");
            return;
        }
        writer.write(62);
        for (XMLNode node : this.getChildNodes()) {
            node.buildTextContent(writer, unEscape);
        }
        if (this.hasChildNodes()) {
            writer.write("</");
            writer.write(this.getTagName());
            writer.write(62);
        }
    }

    private void appendTextContent(Writer writer) throws IOException {
        for (XMLNode child : this.getChildNodes()) {
            if (child instanceof XMLElement) {
                ((XMLElement)child).setIndent(0);
            }
            child.write(writer, false);
        }
    }

    public boolean hasChildElements() {
        return this.mChildElements.size() > 0;
    }

    public boolean hasTextContent() {
        return this.mTexts.size() > 0;
    }

    public String getText() {
        if (this.mTexts.size() == 0) {
            return null;
        }
        return this.mTexts.get(0).getText();
    }

    public void setSpannableText(String text) {
        this.clearChildNodes();
        XMLElement element = XMLElement.parseSpanSafe(text);
        if (element == null) {
            this.addText(new XMLText(text));
            return;
        }
        for (XMLNode xmlNode : element.getChildNodes()) {
            super.addChildNode(xmlNode);
        }
    }

    public void setTextContent(String text) {
        this.setTextContent(text, true);
    }

    public void setTextContent(String text, boolean escape) {
        this.clearChildElements();
        this.clearTexts();
        super.getChildNodes().clear();
        if (escape) {
            text = XMLUtil.escapeXmlChars(text);
        }
        this.appendText(text);
    }

    private boolean appendAttributes(Writer writer, boolean newLineAttributes) throws IOException {
        boolean addedOnce = false;
        int attributesIndent = this.calculateAttributesIndent();
        boolean indentAppend = false;
        for (XMLAttribute attr : this.listAttributes()) {
            if (newLineAttributes) {
                indentAppend = this.appendAttributesIndentText(writer, indentAppend, attributesIndent);
            }
            if (addedOnce) {
                if (!indentAppend) {
                    writer.write(32);
                }
            } else {
                writer.write(32);
            }
            attr.write(writer);
            addedOnce = true;
        }
        return addedOnce;
    }

    boolean isEmpty() {
        if (this.mTagName != null) {
            return false;
        }
        if (this.mAttributes.size() > 0) {
            return false;
        }
        if (this.mComments != null && this.mComments.size() > 0) {
            return false;
        }
        return this.mTexts.size() <= 0;
    }

    private boolean canAppendChildes() {
        for (XMLElement child : this.mChildElements) {
            if (child.isEmpty()) continue;
            return true;
        }
        return false;
    }

    boolean appendComments(Writer writer) throws IOException {
        if (this.mComments == null) {
            return false;
        }
        boolean appendPrevious = false;
        boolean addedOnce = false;
        for (XMLComment ce : this.mComments) {
            if (ce.isEmpty()) continue;
            if (appendPrevious) {
                writer.write(XMLUtil.NEW_LINE);
            }
            if (!(appendPrevious = ce.write(writer, false))) continue;
            addedOnce = true;
        }
        return addedOnce;
    }

    private boolean appendChildes(Writer writer, boolean newLineAttributes) throws IOException {
        boolean appendPrevious = true;
        boolean addedOnce = false;
        for (XMLElement child : this.mChildElements) {
            if (this.stopWriting(writer)) break;
            if (child.isEmpty()) continue;
            if (appendPrevious) {
                writer.write(XMLUtil.NEW_LINE);
            }
            appendPrevious = child.write(writer, newLineAttributes);
            if (addedOnce || !appendPrevious) continue;
            addedOnce = true;
        }
        return addedOnce;
    }

    private boolean stopWriting(Writer writer) {
        if (!(writer instanceof ElementWriter)) {
            return false;
        }
        ElementWriter elementWriter = (ElementWriter)writer;
        if (elementWriter.isFinished()) {
            elementWriter.writeInterrupted();
            return true;
        }
        return false;
    }

    @Override
    public boolean write(Writer writer, boolean newLineAttributes) throws IOException {
        if (this.isEmpty()) {
            return false;
        }
        if (this.stopWriting(writer)) {
            return false;
        }
        boolean appendOnce = this.appendComments(writer);
        if (appendOnce) {
            writer.write(XMLUtil.NEW_LINE);
        }
        this.appendIndentText(writer);
        writer.write(this.mStart);
        String tagName = this.getTagName();
        if (tagName != null) {
            writer.write(tagName);
        }
        this.appendAttributes(writer, newLineAttributes);
        boolean useEndTag = false;
        boolean hasTextCon = this.hasTextContent();
        if (hasTextCon) {
            writer.write(this.mEnd);
            this.appendTextContent(writer);
            useEndTag = true;
        } else if (this.canAppendChildes()) {
            writer.write(this.mEnd);
            this.appendChildes(writer, newLineAttributes);
            useEndTag = true;
        }
        if (useEndTag) {
            if (!hasTextCon) {
                writer.write(XMLUtil.NEW_LINE);
                this.appendIndentText(writer);
            }
            writer.write(this.mStart);
            writer.write(this.mStartPrefix);
            writer.write(this.getTagName());
        } else {
            writer.write(this.mEndPrefix);
        }
        writer.write(this.mEnd);
        return true;
    }

    @Override
    public String toText(int indent, boolean newLineAttributes) {
        StringWriter writer = new StringWriter();
        this.setIndent(indent);
        try {
            this.write(writer, newLineAttributes);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    protected List<XMLNode> listSpannable() {
        ArrayList<XMLNode> results = new ArrayList<XMLNode>();
        for (XMLNode child : this.getChildNodes()) {
            if (!(child instanceof XMLElement) && !(child instanceof XMLText)) continue;
            results.add(child);
        }
        return results;
    }

    protected String getSpannableText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTagName());
        for (XMLAttribute attribute : this.listAttributes()) {
            builder.append(' ');
            builder.append(attribute.toText(0, false));
        }
        return builder.toString();
    }

    public String toString() {
        StringWriter strWriter = new StringWriter();
        ElementWriter writer = new ElementWriter(strWriter, 500L);
        try {
            this.write(writer, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        strWriter.flush();
        return strWriter.toString();
    }

    private static XMLElement parseSpanSafe(String spanText) {
        if (spanText == null) {
            return null;
        }
        try {
            XMLSpanParser spanParser = new XMLSpanParser();
            return spanParser.parse(spanText);
        }
        catch (XMLException ignored) {
            return null;
        }
    }
}

