/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.ElementWriter;
import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLException;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import com.reandroid.xml.XmlHeaderElement;
import com.reandroid.xml.parser.XMLDocumentParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;

public class XMLDocument
extends XMLNode {
    private XMLElement mDocumentElement;
    private Object mTag;
    private String mName;
    private String mConfigName;
    private float mIndentScale = 0.5f;
    private XmlHeaderElement mHeaderElement = new XmlHeaderElement();
    private Object mLastElementSorter;

    public XMLDocument(String elementName) {
        this();
        XMLElement docElem = new XMLElement(elementName);
        this.setDocumentElement(docElem);
    }

    public XMLDocument() {
    }

    public void setHeaderElement(XmlHeaderElement headerElement) {
        this.mHeaderElement = headerElement;
    }

    public void hideComments(boolean hide) {
        this.hideComments(true, hide);
    }

    public void hideComments(boolean recursive, boolean hide) {
        if (this.mDocumentElement == null) {
            return;
        }
        this.mDocumentElement.hideComments(recursive, hide);
    }

    public XmlHeaderElement getHeaderElement() {
        return this.mHeaderElement;
    }

    public void sortDocumentElement(Comparator<XMLElement> comparator) {
        if (this.mDocumentElement == null || comparator == null) {
            return;
        }
        if (this.mLastElementSorter != null && this.mLastElementSorter.getClass().equals(comparator.getClass())) {
            return;
        }
        this.mLastElementSorter = comparator;
        this.mDocumentElement.sortChildes(comparator);
    }

    public void setIndentScalePercent(int val) {
        int percent = val > 100 ? 100 : (val < 0 ? 0 : val);
        this.mIndentScale = (float)percent / 100.0f;
        XMLElement docElem = this.getDocumentElement();
        if (docElem != null) {
            docElem.setIndentScale(this.mIndentScale);
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getConfigName() {
        return this.mConfigName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setConfigName(String configName) {
        this.mConfigName = configName;
    }

    public Object getTag() {
        return this.mTag;
    }

    public void setTag(Object obj) {
        this.mTag = obj;
    }

    public XMLElement createElement(String tag) {
        XMLElement docEl = this.getDocumentElement();
        if (docEl == null) {
            docEl = new XMLElement(tag);
            this.setDocumentElement(docEl);
            return docEl;
        }
        XMLElement baseElement = docEl.createElement(tag);
        return baseElement;
    }

    public XMLElement getDocumentElement() {
        return this.mDocumentElement;
    }

    public void setDocumentElement(XMLElement baseElement) {
        this.mDocumentElement = baseElement;
        if (baseElement != null) {
            baseElement.setIndentScale(this.mIndentScale);
        }
    }

    private String getElementString(boolean newLineAttributes) {
        XMLElement baseElement = this.getDocumentElement();
        if (baseElement == null) {
            return null;
        }
        return baseElement.toString();
    }

    private boolean appendDocumentElement(Writer writer, boolean newLineAttributes) throws IOException {
        if (this.mDocumentElement == null) {
            return false;
        }
        return this.mDocumentElement.write(writer, newLineAttributes);
    }

    private boolean appendDocumentAttribute(Writer writer) throws IOException {
        XmlHeaderElement headerElement = this.getHeaderElement();
        if (headerElement == null) {
            return false;
        }
        return headerElement.write(writer, false);
    }

    public boolean saveAndroidResource(File file) throws IOException {
        if (file == null) {
            throw new IOException("File is null");
        }
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file, false);
        return this.saveAndroidResource(out);
    }

    public boolean saveAndroidValuesResource(File file) throws IOException {
        if (file == null) {
            throw new IOException("File is null");
        }
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream out = new FileOutputStream(file, false);
        return this.saveAndroidValuesResource(out);
    }

    public boolean saveAndroidResource(OutputStream out) throws IOException {
        this.setIndent(1);
        this.hideComments(true);
        return this.save(out, true);
    }

    public boolean saveAndroidValuesResource(OutputStream out) throws IOException {
        this.setIndent(1);
        return this.save(out, false);
    }

    public boolean save(OutputStream out, boolean newLineAttributes) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
        boolean result = this.write(writer, newLineAttributes);
        writer.flush();
        writer.close();
        return result;
    }

    public boolean save(File file, boolean newLineAttributes) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        this.setIndent(1);
        FileWriter writer = new FileWriter(file, false);
        boolean result = this.write(writer, newLineAttributes);
        writer.flush();
        writer.close();
        return result;
    }

    @Override
    public boolean write(Writer writer, boolean newLineAttributes) throws IOException {
        boolean has_header = this.appendDocumentAttribute(writer);
        if (has_header) {
            writer.write(XMLUtil.NEW_LINE);
        }
        return this.appendDocumentElement(writer, newLineAttributes);
    }

    @Override
    public String toText(int indent, boolean newLineAttributes) {
        StringWriter writer = new StringWriter();
        this.setIndent(indent);
        try {
            this.write(writer, newLineAttributes);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public String toString() {
        StringWriter strWriter = new StringWriter();
        ElementWriter writer = new ElementWriter(strWriter, 500L);
        try {
            this.write(writer, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        strWriter.flush();
        return strWriter.toString();
    }

    public static XMLDocument load(String text) throws XMLException {
        XMLDocumentParser parser = new XMLDocumentParser(text);
        return parser.parse();
    }

    public static XMLDocument load(InputStream in) throws XMLException {
        if (in == null) {
            throw new XMLException("InputStream=null");
        }
        XMLDocumentParser parser = new XMLDocumentParser(in);
        return parser.parse();
    }

    public static XMLDocument load(File file) throws XMLException {
        XMLDocumentParser parser = new XMLDocumentParser(file);
        XMLDocument resDocument = parser.parse();
        if (resDocument != null && resDocument.getTag() == null) {
            resDocument.setTag(file);
        }
        return resDocument;
    }

    public void setIndent(int indent) {
        XMLElement docEle = this.getDocumentElement();
        if (docEle == null) {
            return;
        }
        docEle.setIndent(indent);
    }
}

