/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.Writer;

public class XMLComment
extends XMLElement {
    private String mStart;
    private String mEnd;
    private boolean mIsHidden;

    public XMLComment(String commentText) {
        this();
        this.setCommentText(commentText);
    }

    public XMLComment() {
        this.initializeStartEnd();
    }

    public void setHidden(boolean hide) {
        this.mIsHidden = hide;
    }

    public boolean isHidden() {
        return this.mIsHidden;
    }

    public void setCommentText(String text) {
        this.setTextContent(text);
    }

    public String getCommentText() {
        return this.getTextContent();
    }

    private void initializeStartEnd() {
        this.setTagName("");
        this.mStart = "<!--";
        this.mEnd = "-->";
        this.setStart(this.mStart);
        this.setEnd(this.mEnd);
        this.setStartPrefix("");
        this.setEndPrefix("");
    }

    @Override
    int getChildIndent() {
        return this.getIndent();
    }

    @Override
    boolean isEmpty() {
        return XMLUtil.isEmpty(this.getTextContent());
    }

    void buildTextContent(Writer writer) throws IOException {
    }

    @Override
    public boolean write(Writer writer, boolean newLineAttributes) throws IOException {
        if (this.isHidden()) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        boolean appendOnce = this.appendComments(writer);
        if (appendOnce) {
            writer.write(XMLUtil.NEW_LINE);
        }
        this.appendIndentText(writer);
        writer.write(this.mStart);
        writer.write(this.getCommentText());
        writer.write(this.mEnd);
        return true;
    }
}

