/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLElement;
import com.reandroid.xml.XMLNode;
import com.reandroid.xml.XMLUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class XMLAttribute
extends XMLNode {
    private int mNameId;
    private int mValueId;
    private String mName;
    private String mValue;
    private XMLElement mParent;

    public XMLAttribute(String name, String val) {
        this.mName = name;
        this.mValue = XMLUtil.escapeXmlChars(val);
    }

    public XMLElement getParent() {
        return this.mParent;
    }

    void setParent(XMLElement parent) {
        this.mParent = parent;
    }

    public void setNameId(int id) {
        this.mNameId = id;
    }

    public void setValueId(int id) {
        this.mValueId = id;
    }

    public int getNameId() {
        return this.mNameId;
    }

    public int getValueId() {
        return this.mValueId;
    }

    public XMLAttribute cloneAttr() {
        XMLAttribute baseAttr = new XMLAttribute(this.getName(), this.getValue());
        baseAttr.setNameId(this.getNameId());
        baseAttr.setValueId(this.getValueId());
        return baseAttr;
    }

    public String getName() {
        return this.mName;
    }

    public String getNamePrefix() {
        int i = this.mName.indexOf(":");
        if (i > 0) {
            return this.mName.substring(0, i);
        }
        return null;
    }

    public String getNameWoPrefix() {
        int i = this.mName.indexOf(":");
        if (i > 0) {
            return this.mName.substring(i + 1);
        }
        return this.mName;
    }

    public String getValue() {
        if (this.mValue == null) {
            this.mValue = "";
        }
        return this.mValue;
    }

    public int getValueInt() {
        long l = Long.decode(this.getValue());
        return (int)l;
    }

    public boolean getValueBool() {
        String str = this.getValue().toLowerCase();
        return "true".equals(str);
    }

    public boolean isValueBool() {
        String str = this.getValue().toLowerCase();
        if ("true".equals(str)) {
            return true;
        }
        return "false".equals(str);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setValue(String val) {
        this.mValue = XMLUtil.escapeXmlChars(val);
    }

    @Override
    public boolean write(Writer writer, boolean newLineAttributes) throws IOException {
        writer.write(this.getName());
        writer.write("=\"");
        String val = XMLUtil.trimQuote(this.getValue());
        val = XMLUtil.escapeXmlChars(val);
        val = XMLUtil.escapeQuote(val);
        writer.write(val);
        writer.write(34);
        return true;
    }

    @Override
    public String toText(int indent, boolean newLineAttributes) {
        StringWriter writer = new StringWriter();
        try {
            this.write(writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        writer.flush();
        return writer.toString();
    }

    public int hashCode() {
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        return name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof XMLAttribute) {
            XMLAttribute attr = (XMLAttribute)obj;
            return this.getName().equals(attr.getName());
        }
        return false;
    }

    public String toString() {
        return this.toText();
    }
}

