/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.XMLAttribute;
import com.reandroid.xml.XMLUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaAttr
extends XMLAttribute {
    private static final String DEFAULT_XMLNS = "xmlns";
    private String mXmlns;
    private String mPrefix;
    private static final Pattern PATTERN_URI = Pattern.compile("^\\s*(https?://[^:\\s]+)(:([^:/\\s]+))?\\s*$");

    public SchemaAttr(String prefix, String uri) {
        this(DEFAULT_XMLNS, prefix, uri);
    }

    public SchemaAttr(String xmlns, String prefix, String uri) {
        super(prefix, uri);
        this.set(xmlns, prefix, uri);
    }

    private void set(String xmlns, String prefix, String uri) {
        this.setXmlns(xmlns);
        if (XMLUtil.isEmpty(prefix)) {
            prefix = null;
        }
        this.setName(prefix);
        this.setUri(uri);
    }

    @Override
    public void setName(String fullName) {
        if (fullName == null) {
            this.setPrefix(null);
            return;
        }
        int i = fullName.indexOf(58);
        if (i > 0 && i < fullName.length()) {
            this.mXmlns = fullName.substring(0, i);
            this.mPrefix = fullName.substring(i + 1);
        } else {
            this.setPrefix(fullName);
        }
    }

    public String getXmlns() {
        return this.mXmlns;
    }

    public String getPrefix() {
        return this.mPrefix;
    }

    public void setPrefix(String prefix) {
        this.mPrefix = prefix;
    }

    public void setXmlns(String xmlns) {
        if (XMLUtil.isEmpty(xmlns)) {
            xmlns = DEFAULT_XMLNS;
        }
        this.mXmlns = xmlns;
    }

    public String getUri() {
        return super.getValue();
    }

    public void setUri(String uri) {
        if (uri == null) {
            super.setValue(null);
            return;
        }
        Matcher matcher = PATTERN_URI.matcher(uri);
        if (!matcher.find()) {
            super.setValue(uri);
            return;
        }
        String prf = matcher.group(3);
        if (!XMLUtil.isEmpty(prf)) {
            this.setPrefix(prf);
        }
        uri = matcher.group(1);
        super.setValue(uri);
    }

    @Override
    public XMLAttribute cloneAttr() {
        SchemaAttr attr = new SchemaAttr(this.getXmlns(), this.getPrefix(), this.getUri());
        attr.setNameId(this.getNameId());
        attr.setValueId(this.getValueId());
        return attr;
    }

    @Override
    public String getName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getXmlns());
        builder.append(':');
        String prf = this.getPrefix();
        if (prf == null) {
            prf = "NULL";
        }
        builder.append(prf);
        return builder.toString();
    }

    public static boolean looksSchema(String name, String value) {
        return value != null && name.startsWith("xmlns:");
    }

    public static String getPrefix(String xmlnsName) {
        String start = "xmlns:";
        if (!xmlnsName.startsWith("xmlns:")) {
            return null;
        }
        return xmlnsName.substring(start.length());
    }
}

