/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import com.reandroid.xml.SchemaAttr;
import com.reandroid.xml.XMLUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NameSpaceItem {
    private String prefix;
    private String namespaceUri;
    private static NameSpaceItem ns_android;
    private static NameSpaceItem ns_app;
    private static final Pattern PATTERN_URI;
    private static final String ATTR_PREFIX = "xmlns";
    private static final String URI_ANDROID = "http://schemas.android.com/apk/res/android";
    private static final String URI_APP = "http://schemas.android.com/apk/res-auto";
    private static final String NAME_ANDROID = "android";
    private static final String NAME_APP = "app";

    public NameSpaceItem(String prefix, String nsUri) {
        this.prefix = prefix;
        this.namespaceUri = nsUri;
        this.validate();
    }

    public String toAttributeName() {
        return "xmlns:" + this.prefix;
    }

    public SchemaAttr toSchemaAttribute() {
        return new SchemaAttr(this.getPrefix(), this.getNamespaceUri());
    }

    public boolean isPrefixEqual(String p) {
        if (XMLUtil.isEmpty(this.prefix)) {
            return false;
        }
        return this.prefix.equals(p);
    }

    public boolean isUriEqual(String nsUri) {
        if (XMLUtil.isEmpty(this.namespaceUri)) {
            return false;
        }
        return this.namespaceUri.equals(nsUri);
    }

    public boolean isValid() {
        return this.isPrefixValid() && this.isUriValid();
    }

    private boolean validate() {
        boolean preOk = this.isPrefixValid();
        boolean uriOk = this.isUriValid();
        if (preOk && uriOk) {
            if (!NAME_ANDROID.equals(this.prefix) && URI_ANDROID.equals(this.namespaceUri)) {
                this.namespaceUri = URI_APP;
            }
            return true;
        }
        if (!preOk && !uriOk) {
            return false;
        }
        if (!preOk) {
            this.prefix = URI_ANDROID.equals(this.namespaceUri) ? NAME_ANDROID : NAME_APP;
        }
        if (!uriOk) {
            this.namespaceUri = NAME_ANDROID.equals(this.prefix) ? URI_ANDROID : URI_APP;
        }
        return true;
    }

    private boolean isPrefixValid() {
        return !XMLUtil.isEmpty(this.prefix);
    }

    private boolean isUriValid() {
        if (XMLUtil.isEmpty(this.namespaceUri)) {
            return false;
        }
        Matcher matcher = PATTERN_URI.matcher(this.namespaceUri);
        return matcher.find();
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
        this.validate();
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.validate();
    }

    public boolean equals(Object o) {
        if (o instanceof NameSpaceItem) {
            return this.isUriEqual(((NameSpaceItem)o).namespaceUri);
        }
        return false;
    }

    public int hashCode() {
        String u = this.namespaceUri;
        if (u == null) {
            u = "";
        }
        return u.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        if (this.namespaceUri != null) {
            builder.append(this.namespaceUri);
            appendOnce = true;
        }
        if (this.prefix != null) {
            if (appendOnce) {
                builder.append(':');
            }
            builder.append(this.prefix);
        }
        return builder.toString();
    }

    public static NameSpaceItem getAndroid() {
        if (ns_android == null) {
            ns_android = new NameSpaceItem(NAME_ANDROID, URI_ANDROID);
        }
        return ns_android;
    }

    public static NameSpaceItem getApp() {
        if (ns_app == null) {
            ns_app = new NameSpaceItem(NAME_APP, URI_APP);
        }
        return ns_app;
    }

    static {
        PATTERN_URI = Pattern.compile("^https?://[^\\s/]+/[^\\s]+$");
    }
}

