/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.xml;

import java.io.IOException;
import java.io.Writer;

class ElementWriter
extends Writer {
    private final Writer mWriter;
    private final long mMaxLen;
    private final boolean mUnlimitedLength;
    private long mCurrentLength;
    private boolean mLengthFinished;
    private boolean mInterruptedWritten;

    ElementWriter(Writer writer, long maxLen) {
        this.mWriter = writer;
        this.mMaxLen = maxLen;
        this.mUnlimitedLength = maxLen < 0L;
    }

    ElementWriter(Writer writer) {
        this(writer, -1L);
    }

    boolean isFinished() {
        return this.mLengthFinished;
    }

    void writeInterrupted() {
        if (!this.mLengthFinished) {
            return;
        }
        if (this.mInterruptedWritten) {
            return;
        }
        this.mInterruptedWritten = true;
        String txt = "\n      .\n      .\n      .\n   more items ...\n";
        try {
            this.mWriter.write(txt);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(char[] chars, int i, int i1) throws IOException {
        this.updateCurrentLength(i1);
        this.mWriter.write(chars, i, i1);
    }

    @Override
    public void flush() throws IOException {
        this.mWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.mWriter.close();
    }

    private boolean updateCurrentLength(int len) {
        if (this.mUnlimitedLength) {
            return false;
        }
        if (this.mLengthFinished) {
            this.mLengthFinished = true;
        }
        this.mCurrentLength += (long)len;
        this.mLengthFinished = this.mCurrentLength >= this.mMaxLen;
        return this.mLengthFinished;
    }
}

