/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.identifiers.Identifier;
import com.reandroid.identifiers.PackageIdentifier;
import com.reandroid.identifiers.TypeIdentifier;
import java.io.IOException;
import org.xmlpull.v1.XmlSerializer;

public class ResourceIdentifier
extends Identifier {
    private Boolean mHasGoodName;
    public static final int NAME_LENGTH_MIN = 2;
    public static final int NAME_LENGTH_MAX = 100;

    public ResourceIdentifier(int id, String name) {
        super(id, name);
    }

    public ResourceIdentifier() {
        this(0, null);
    }

    public void write(XmlSerializer serializer) throws IOException {
        serializer.text("\n  ");
        serializer.startTag(null, "public");
        serializer.attribute(null, "id", this.getHexId());
        serializer.attribute(null, "type", this.getTypeName());
        serializer.attribute(null, "name", this.getName());
        serializer.endTag(null, "public");
    }

    public TypeIdentifier getTypeIdentifier() {
        return (TypeIdentifier)this.getParent();
    }

    public void setTypeIdentifier(TypeIdentifier typeIdentifier) {
        this.setParent(typeIdentifier);
    }

    public PackageIdentifier getPackageIdentifier() {
        TypeIdentifier typeIdentifier = this.getTypeIdentifier();
        if (typeIdentifier != null) {
            return typeIdentifier.getPackageIdentifier();
        }
        return null;
    }

    public String getTypeName() {
        TypeIdentifier typeIdentifier = this.getTypeIdentifier();
        if (typeIdentifier != null) {
            return typeIdentifier.getName();
        }
        return null;
    }

    public String getPackageName() {
        TypeIdentifier typeIdentifier = this.getTypeIdentifier();
        if (typeIdentifier != null) {
            return typeIdentifier.getPackageName();
        }
        return null;
    }

    public int getTypeId() {
        TypeIdentifier typeIdentifier = this.getTypeIdentifier();
        if (typeIdentifier != null) {
            return typeIdentifier.getId();
        }
        return 0;
    }

    public int getPackageId() {
        TypeIdentifier typeIdentifier = this.getTypeIdentifier();
        if (typeIdentifier != null) {
            return typeIdentifier.getPackageId();
        }
        return 0;
    }

    public int getResourceId() {
        int resourceId = this.getPackageId() << 24;
        resourceId |= this.getTypeId() << 16;
        return resourceId |= this.getId();
    }

    @Override
    public void setId(int id) {
        super.setId(id & 0xFFFF);
    }

    @Override
    public String getHexId() {
        return HexUtil.toHex8(this.getResourceId());
    }

    public String getResourceName() {
        return this.getResourceName(null);
    }

    public String getResourceName(PackageIdentifier context) {
        boolean appendPackage = context != this.getPackageIdentifier();
        return this.getResourceName('@', appendPackage, true);
    }

    public String getResourceName(char prefix, boolean appendPackage, boolean appendType) {
        String packageName = appendPackage ? this.getPackageName() : null;
        String typeName = appendType ? this.getTypeName() : null;
        return ResourceIdentifier.buildResourceName(prefix, packageName, typeName, this.getName());
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.mHasGoodName = null;
    }

    @Override
    long getUniqueId() {
        return 0xFFFFFFFFL & (long)this.getResourceId();
    }

    @Override
    public void setTag(Object tag) {
        TypeIdentifier ti = this.getTypeIdentifier();
        if (ti == null) {
            super.setTag(tag);
            return;
        }
        Object exist = this.getTag();
        if (exist != null) {
            ti.removeTag(exist);
        }
        ti.addTag(tag, this);
        super.setTag(tag);
    }

    public String generateUniqueName() {
        String type = this.getTypeName();
        if (type == null) {
            type = "res";
        }
        return type + "_" + this.getHexId();
    }

    public boolean isGeneratedName() {
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (!name.contains("_0x")) {
            return false;
        }
        return this.generateUniqueName().equals(name);
    }

    public boolean renameSpecGenerated() {
        this.setName(this.generateUniqueName());
        return this.renameSpec();
    }

    public boolean renameBadSpec() {
        if (this.hasGoodName()) {
            return false;
        }
        this.setName(this.generateUniqueName());
        return this.renameSpec();
    }

    public boolean renameSpec() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return false;
        }
        EntryGroup entryGroup = packageBlock.getEntryGroup(this.getResourceId());
        if (entryGroup == null) {
            return false;
        }
        String name = this.getName();
        if (name == null) {
            return false;
        }
        if (name.equals(entryGroup.getSpecName())) {
            return false;
        }
        return entryGroup.renameSpec(name);
    }

    private PackageBlock getPackageBlock() {
        PackageIdentifier pi = this.getPackageIdentifier();
        if (pi != null) {
            return pi.getPackageBlock();
        }
        return null;
    }

    public boolean hasGoodName() {
        if (this.mHasGoodName == null) {
            this.mHasGoodName = ResourceIdentifier.isGoodName(this.getName());
        }
        return this.mHasGoodName;
    }

    @Override
    public String toString() {
        return this.getHexId() + " " + this.getResourceName();
    }

    public static String buildResourceName(char prefix, String packageName, String type, String entry) {
        StringBuilder builder = new StringBuilder();
        if (prefix != '\u0000') {
            builder.append(prefix);
        }
        if (packageName != null) {
            builder.append(packageName);
            builder.append(':');
        }
        if (type != null) {
            builder.append(type);
            builder.append('/');
        }
        builder.append(entry);
        return builder.toString();
    }

    public static boolean isGoodName(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length < 2 || length > 100) {
            return false;
        }
        char[] chars = name.toCharArray();
        if (!ResourceIdentifier.isGoodFirstChar(chars[0])) {
            return false;
        }
        length = chars.length;
        for (int i = 1; i < length; ++i) {
            if (ResourceIdentifier.isGoodNameChar(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isGoodNameChar(char ch) {
        return ResourceIdentifier.isAtoZ(ch) || ResourceIdentifier.isDigits(ch) || ch == '_' || ch == '.';
    }

    private static boolean isGoodFirstChar(char ch) {
        return ResourceIdentifier.isAtoZ(ch) || ch == '_' || ch == '$';
    }

    private static boolean isAtoZ(char ch) {
        if (ch >= 'A' && ch <= 'Z') {
            return true;
        }
        return ch >= 'a' && ch <= 'z';
    }

    private static boolean isDigits(char ch) {
        return ch >= '0' && ch <= '9';
    }
}

