/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.identifiers;

import com.android.org.kxml2.io.KXmlParser;
import com.android.org.kxml2.io.KXmlSerializer;
import com.reandroid.arsc.array.EntryArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TypeStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.identifiers.IdentifierMap;
import com.reandroid.identifiers.ResourceIdentifier;
import com.reandroid.identifiers.TypeIdentifier;
import com.reandroid.json.JSONObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PackageIdentifier
extends IdentifierMap<TypeIdentifier> {
    private PackageBlock mPackageBlock;
    private int mPackageLoadStamp;

    public PackageIdentifier(int id, String name) {
        super(id, name);
    }

    public PackageIdentifier() {
        this(0, null);
    }

    public void initialize(PackageBlock packageBlock) {
        this.initialize(packageBlock, true);
    }

    public void initialize(PackageBlock packageBlock, boolean initialize_ids) {
        packageBlock.setId(this.getId());
        String name = this.getName();
        if (name != null) {
            packageBlock.setName(name);
        }
        this.initializeTypeName(packageBlock.getTypeStringPool());
        this.initializeSpecNames(packageBlock.getSpecStringPool());
        if (initialize_ids) {
            this.initializeIds(packageBlock);
        }
        this.initializePackageJson(packageBlock);
        this.mPackageLoadStamp = packageBlock.getEntryGroupCount();
        this.setPackageBlock(packageBlock);
    }

    private void initializeTypeName(TypeStringPool typeStringPool) {
        for (TypeIdentifier ti : this.list()) {
            typeStringPool.getOrCreate(ti.getId(), ti.getName());
        }
    }

    private void initializeSpecNames(SpecStringPool specStringPool) {
        ArrayList<String> nameList = new ArrayList<String>(this.getResourcesCount());
        for (TypeIdentifier ti : this.list()) {
            nameList.addAll(ti.listNames());
        }
        specStringPool.addStrings(nameList);
    }

    private void initializeIds(PackageBlock packageBlock) {
        TypeIdentifier identifierID = (TypeIdentifier)this.get("id");
        if (identifierID == null) {
            return;
        }
        TypeBlock typeBlock = packageBlock.getOrCreateTypeBlock("", "id");
        EntryArray entryArray = typeBlock.getEntryArray();
        entryArray.ensureSize(identifierID.size());
        SpecStringPool specStringPool = packageBlock.getSpecStringPool();
        for (ResourceIdentifier ri : identifierID.list()) {
            Entry entry = entryArray.getOrCreate((short)ri.getId());
            SpecString specString = (SpecString)specStringPool.getOrCreate(ri.getName());
            if (!entry.isNull() && !entry.isComplex()) {
                entry.setSpecReference(specString);
                continue;
            }
            entry.setValueAsBoolean(false);
            entry.setSpecReference(specString);
            this.setIdEntryVisibility(entry);
        }
    }

    private void setIdEntryVisibility(Entry entry) {
        ValueHeader valueHeader = entry.getHeader();
        valueHeader.setWeak(true);
        valueHeader.setPublic(true);
    }

    private void initializePackageJson(PackageBlock packageBlock) {
        File jsonFile = this.searchPackageJsonFromTag();
        if (jsonFile == null) {
            return;
        }
        try {
            JSONObject jsonObject = new JSONObject(new FileInputStream(jsonFile));
            packageBlock.fromJson(jsonObject);
            if (this.getName() == null) {
                this.setName(packageBlock.getName());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private File searchPackageJsonFromTag() {
        Object tag = this.getTag();
        if (!(tag instanceof File)) {
            return null;
        }
        File publicXml = (File)tag;
        File dir = publicXml.getParentFile();
        if (dir == null || !"values".equals(dir.getName())) {
            return null;
        }
        if ((dir = dir.getParentFile()) == null) {
            return null;
        }
        if ((dir = dir.getParentFile()) == null) {
            return null;
        }
        File json = new File(dir, "package.json");
        if (!json.isFile()) {
            return null;
        }
        return json;
    }

    public List<ResourceIdentifier> listDuplicateResources() {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (TypeIdentifier typeIdentifier : this.list()) {
            results.addAll(typeIdentifier.listDuplicates());
        }
        return results;
    }

    public boolean hasDuplicateResources() {
        for (TypeIdentifier typeIdentifier : this.getItems()) {
            if (!typeIdentifier.hasDuplicates()) continue;
            return true;
        }
        return false;
    }

    public List<ResourceIdentifier> ensureUniqueResourceNames() {
        ArrayList<ResourceIdentifier> results = new ArrayList<ResourceIdentifier>();
        for (TypeIdentifier typeIdentifier : this.list()) {
            results.addAll(typeIdentifier.ensureUniqueResourceNames());
        }
        return results;
    }

    public void setResourceNamesToPackage() {
        this.setResourceNamesToPackage(this.getPackageBlock());
    }

    public void setResourceNamesToPackage(PackageBlock packageBlock) {
        if (packageBlock == null) {
            return;
        }
        for (EntryGroup entryGroup : packageBlock.listEntryGroup()) {
            this.setResourceNamesToEntry(entryGroup);
        }
    }

    public void setResourceNamesToEntry(EntryGroup entryGroup) {
        ResourceIdentifier ri = this.getResourceIdentifier(entryGroup.getResourceId());
        if (ri == null) {
            return;
        }
        entryGroup.renameSpec(ri.getName());
    }

    public ResourceIdentifier getResourceIdentifier(int resourceId) {
        TypeIdentifier typeIdentifier = (TypeIdentifier)this.get(resourceId >> 16 & 0xFF);
        if (typeIdentifier != null) {
            return (ResourceIdentifier)typeIdentifier.get(resourceId & 0xFFFF);
        }
        return null;
    }

    public ResourceIdentifier getResourceIdentifier(String type, String name) {
        TypeIdentifier typeIdentifier = (TypeIdentifier)this.get(type);
        if (typeIdentifier != null) {
            return (ResourceIdentifier)typeIdentifier.get(name);
        }
        return null;
    }

    public int getResourcesCount() {
        int result = 0;
        for (TypeIdentifier ti : this.getItems()) {
            result += ti.size();
        }
        return result;
    }

    public void writePublicXml(File file) throws IOException {
        File dir = file.getParentFile();
        if (dir != null && !dir.exists()) {
            dir.mkdirs();
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        this.writePublicXml(outputStream);
        outputStream.close();
    }

    public void writePublicXml(OutputStream outputStream) throws IOException {
        KXmlSerializer serializer = new KXmlSerializer();
        serializer.setOutput(outputStream, StandardCharsets.UTF_8.name());
        this.write(serializer);
    }

    public void write(XmlSerializer serializer) throws IOException {
        this.updateChangedPackageBlock();
        serializer.startDocument("utf-8", null);
        serializer.text("\n");
        serializer.startTag(null, "resources");
        this.writePackageInfo(serializer);
        this.writeTypes(serializer);
        serializer.text("\n");
        serializer.endTag(null, "resources");
        serializer.endDocument();
        this.closeSerializer(serializer);
    }

    private void writePackageInfo(XmlSerializer serializer) throws IOException {
        int id;
        String name = this.getName();
        if (name != null) {
            serializer.attribute(null, "package", name);
        }
        if ((id = this.getId()) != 0) {
            serializer.attribute(null, "id", HexUtil.toHex2((byte)id));
        }
    }

    private void writeTypes(XmlSerializer serializer) throws IOException {
        for (TypeIdentifier typeIdentifier : this.list()) {
            typeIdentifier.write(serializer);
        }
    }

    public void load(PackageBlock packageBlock) {
        this.setId(packageBlock.getId());
        this.setName(packageBlock.getName());
        this.loadEntryGroups(packageBlock);
        this.setPackageBlock(packageBlock);
    }

    private void updateChangedPackageBlock() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return;
        }
        if (packageBlock.getEntryGroupCount() == this.mPackageLoadStamp) {
            return;
        }
        this.loadEntryGroups(packageBlock);
    }

    private void loadEntryGroups(PackageBlock packageBlock) {
        for (EntryGroup entryGroup : packageBlock.listEntryGroup()) {
            this.add(entryGroup);
        }
        this.mPackageLoadStamp = packageBlock.getEntryGroupCount();
    }

    public void loadPublicXml(File file) throws IOException, XmlPullParserException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.loadPublicXml(fileInputStream);
        fileInputStream.close();
    }

    public void loadPublicXml(InputStream inputStream) throws IOException, XmlPullParserException {
        KXmlParser parser = new KXmlParser();
        parser.setInput(inputStream, StandardCharsets.UTF_8.name());
        this.loadPublicXml(parser);
    }

    public void loadPublicXml(Reader reader) throws IOException, XmlPullParserException {
        KXmlParser parser = new KXmlParser();
        parser.setInput(reader);
        this.loadPublicXml(parser);
    }

    public void loadPublicXml(XmlPullParser parser) throws IOException, XmlPullParserException {
        int event;
        boolean resourcesFound = false;
        while ((event = parser.nextToken()) != 1) {
            if (event != 2) continue;
            if (!resourcesFound) {
                resourcesFound = parser.getName().equals("resources");
                if (!resourcesFound) {
                    throw new XmlPullParserException("Invalid public.xml, expecting first tag '" + this.getName() + "' " + parser.getPositionDescription());
                }
                this.loadPackageInfo(parser);
                continue;
            }
            this.parseEntry(parser);
        }
        this.closeParser(parser);
    }

    private void closeParser(XmlPullParser parser) {
        if (!(parser instanceof Closeable)) {
            return;
        }
        Closeable closeable = (Closeable)((Object)parser);
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeSerializer(XmlSerializer serializer) {
        if (!(serializer instanceof Closeable)) {
            return;
        }
        Closeable closeable = (Closeable)((Object)serializer);
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void loadPackageInfo(XmlPullParser parser) {
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            int id;
            if ("package".equals(parser.getAttributeName(i))) {
                this.setName(parser.getAttributeValue(i));
                continue;
            }
            if (!"id".equals(parser.getAttributeName(i)) || (id = Integer.decode(parser.getAttributeValue(i)).intValue()) == 0) continue;
            this.setId(id);
        }
    }

    private void parseEntry(XmlPullParser parser) throws XmlPullParserException {
        if (!"public".equals(parser.getName())) {
            throw new XmlPullParserException("Invalid tag, expecting 'public' " + parser.getPositionDescription());
        }
        String resourceIdStr = null;
        String typeName = null;
        String entryName = null;
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String attrName = parser.getAttributeName(i);
            String value = parser.getAttributeValue(i);
            if ("id".equals(attrName)) {
                resourceIdStr = value;
                continue;
            }
            if ("type".equals(attrName)) {
                typeName = value;
                continue;
            }
            if (!"name".equals(attrName)) continue;
            entryName = value;
        }
        if (typeName == null) {
            throw new XmlPullParserException("Missing attribute 'type' " + parser.getPositionDescription());
        }
        if (resourceIdStr == null) {
            throw new XmlPullParserException("Missing attribute 'id' " + parser.getPositionDescription());
        }
        if (entryName == null) {
            throw new XmlPullParserException("Missing attribute 'name' " + parser.getPositionDescription());
        }
        int resourceId = (int)Long.decode(resourceIdStr).longValue();
        int packageId = resourceId >> 24 & 0xFF;
        int typeId = resourceId >> 16 & 0xFF;
        int entryId = resourceId & 0xFFFF;
        TypeIdentifier typeIdentifier = this.getOrCreate(typeId, typeName);
        ResourceIdentifier entry = new ResourceIdentifier(entryId, entryName);
        typeIdentifier.add(entry);
        if (this.getId() == 0) {
            this.setId(packageId);
        }
    }

    public PackageBlock getPackageBlock() {
        return this.mPackageBlock;
    }

    public void setPackageBlock(PackageBlock packageBlock) {
        this.mPackageBlock = packageBlock;
    }

    @Override
    public void add(EntryGroup entryGroup) {
        this.add(entryGroup.pickOne());
    }

    @Override
    public void add(Entry entry) {
        if (entry == null || entry.isNull()) {
            return;
        }
        TypeBlock typeBlock = entry.getTypeBlock();
        TypeIdentifier typeIdentifier = this.getOrCreate(typeBlock.getId(), typeBlock.getTypeName());
        ResourceIdentifier resourceIdentifier = new ResourceIdentifier(entry.getId(), entry.getName());
        typeIdentifier.add(resourceIdentifier);
    }

    private TypeIdentifier getOrCreate(int typeId, String typeName) {
        TypeIdentifier identifier = (TypeIdentifier)this.get(typeId);
        if (identifier == null) {
            return super.add(new TypeIdentifier(typeId, typeName));
        }
        if (typeName != null && identifier.getName() == null) {
            identifier.setName(typeName);
            identifier = super.add(identifier);
        }
        return identifier;
    }

    @Override
    public void clear() {
        for (TypeIdentifier identifier : this.getItems()) {
            identifier.clear();
        }
        super.clear();
    }

    public int renameSpecs() {
        int result = 0;
        for (TypeIdentifier ti : this.getItems()) {
            int renamed = ti.renameSpecs();
            result += renamed;
        }
        return result;
    }

    public int renameDuplicateSpecs() {
        int result = 0;
        for (TypeIdentifier ti : this.getItems()) {
            int renamed = ti.renameDuplicateSpecs();
            result += renamed;
        }
        return result;
    }

    public int renameBadSpecs() {
        int result = 0;
        for (TypeIdentifier ti : this.getItems()) {
            int renamed = ti.renameBadSpecs();
            result += renamed;
        }
        return result;
    }

    public String validateSpecNames() {
        int duplicates = this.renameDuplicateSpecs();
        int bad = this.renameBadSpecs();
        if (duplicates == 0 && bad == 0) {
            return null;
        }
        return "Spec names validated, duplicates = " + duplicates + ", bad = " + bad;
    }

    @Override
    void setCaseInsensitive(boolean caseInsensitive) {
        super.setCaseInsensitive(caseInsensitive);
        for (TypeIdentifier ti : this.getItems()) {
            ti.setCaseInsensitive(caseInsensitive);
        }
    }
}

