/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.FrameworkTable;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.StagedAliasEntry;
import com.reandroid.common.EntryStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TableEntryStore
implements EntryStore {
    private final Map<Integer, Set<PackageBlock>> mLocalPackagesMap = new HashMap<Integer, Set<PackageBlock>>();
    private final Map<Integer, Set<PackageBlock>> mFrameworkPackagesMap = new HashMap<Integer, Set<PackageBlock>>();

    public String getEntryName(int resourceId) {
        Entry entry = this.getEntry(resourceId);
        if (entry == null) {
            return null;
        }
        return entry.getName();
    }

    public Entry getEntry(int resourceId) {
        if (resourceId == 0) {
            return null;
        }
        EntryGroup entryGroup = this.getEntryGroup(resourceId);
        if (entryGroup == null) {
            return null;
        }
        return entryGroup.pickOne();
    }

    public void add(TableBlock tableBlock) {
        if (tableBlock == null) {
            return;
        }
        for (PackageBlock packageBlock : tableBlock.listPackages()) {
            this.add(packageBlock);
        }
    }

    public void add(PackageBlock packageBlock) {
        if (packageBlock == null) {
            return;
        }
        Set<PackageBlock> packageBlockSet = packageBlock.getTableBlock() instanceof FrameworkTable ? this.getOrCreateFrameworks(packageBlock.getId()) : this.getOrCreateLocal(packageBlock.getId());
        if (packageBlockSet.contains(packageBlock)) {
            return;
        }
        packageBlockSet.add(packageBlock);
    }

    private Set<PackageBlock> getOrCreateLocal(int packageId) {
        Integer id = packageId;
        Set<PackageBlock> packageBlockSet = this.mLocalPackagesMap.get(id);
        if (packageBlockSet == null) {
            packageBlockSet = new HashSet<PackageBlock>();
            this.mLocalPackagesMap.put(id, packageBlockSet);
        }
        return packageBlockSet;
    }

    private Set<PackageBlock> getOrCreateFrameworks(int packageId) {
        Integer id = packageId;
        Set<PackageBlock> packageBlockSet = this.mFrameworkPackagesMap.get(id);
        if (packageBlockSet == null) {
            packageBlockSet = new HashSet<PackageBlock>();
            this.mFrameworkPackagesMap.put(id, packageBlockSet);
        }
        return packageBlockSet;
    }

    public List<EntryGroup> getEntryGroups(int resourceId) {
        List<EntryGroup> results = this.searchEntryGroupsLocal(resourceId);
        if (results.size() > 0) {
            return results;
        }
        int alias = this.searchIdAliasLocal(resourceId);
        results = this.searchEntryGroupsLocal(alias);
        if (results.size() > 0) {
            return results;
        }
        results = this.searchEntryGroupsFramework(resourceId);
        if (results.size() > 0) {
            return results;
        }
        alias = this.searchIdAliasFramework(resourceId);
        return this.searchEntryGroupsFramework(alias);
    }

    @Override
    public EntryGroup getEntryGroup(int resourceId) {
        EntryGroup entryGroup = this.searchEntryLocal(resourceId);
        if (entryGroup == null) {
            entryGroup = this.searchEntryLocal(this.searchIdAliasLocal(resourceId));
        }
        if (entryGroup == null) {
            entryGroup = this.searchEntryFramework(resourceId);
        }
        if (entryGroup == null) {
            entryGroup = this.searchEntryFramework(this.searchIdAliasFramework(resourceId));
        }
        return entryGroup;
    }

    public List<PackageBlock> getPackageBlocks(int packageId) {
        ArrayList<PackageBlock> results = new ArrayList<PackageBlock>();
        Set<PackageBlock> packageBlockSet = this.mLocalPackagesMap.get(packageId = 0xFF & packageId);
        if (packageBlockSet == null) {
            packageBlockSet = this.mFrameworkPackagesMap.get(packageId);
        }
        if (packageBlockSet != null) {
            results.addAll(packageBlockSet);
        }
        return results;
    }

    private List<EntryGroup> searchEntryGroupsLocal(int resourceId) {
        if (resourceId == 0) {
            return new ArrayList<EntryGroup>();
        }
        ArrayList<EntryGroup> results = new ArrayList<EntryGroup>();
        int pkgId = resourceId >> 24 & 0xFF;
        Set<PackageBlock> packageBlockSet = this.mLocalPackagesMap.get(pkgId);
        if (packageBlockSet == null) {
            return results;
        }
        for (PackageBlock packageBlock : packageBlockSet) {
            EntryGroup group = packageBlock.getEntryGroup(resourceId);
            if (group == null) continue;
            results.add(group);
        }
        return results;
    }

    private List<EntryGroup> searchEntryGroupsFramework(int resourceId) {
        if (resourceId == 0) {
            return new ArrayList<EntryGroup>();
        }
        ArrayList<EntryGroup> results = new ArrayList<EntryGroup>();
        int pkgId = resourceId >> 24 & 0xFF;
        Set<PackageBlock> packageBlockSet = this.mFrameworkPackagesMap.get(pkgId);
        if (packageBlockSet == null) {
            return results;
        }
        for (PackageBlock packageBlock : packageBlockSet) {
            EntryGroup group = packageBlock.getEntryGroup(resourceId);
            if (group == null) continue;
            results.add(group);
        }
        return results;
    }

    private EntryGroup searchEntryLocal(int resourceId) {
        int packageId = resourceId >> 24 & 0xFF;
        Set<PackageBlock> packageBlockSet = this.mLocalPackagesMap.get(packageId);
        if (packageBlockSet == null) {
            return null;
        }
        for (PackageBlock packageBlock : packageBlockSet) {
            EntryGroup group = packageBlock.getEntryGroup(resourceId);
            if (group == null || group.pickOne() == null) continue;
            return group;
        }
        return null;
    }

    private EntryGroup searchEntryFramework(int resourceId) {
        int packageId = resourceId >> 24 & 0xFF;
        Set<PackageBlock> packageBlockSet = this.mFrameworkPackagesMap.get(packageId);
        if (packageBlockSet == null) {
            return null;
        }
        for (PackageBlock packageBlock : packageBlockSet) {
            EntryGroup group = packageBlock.getEntryGroup(resourceId);
            if (group == null || group.pickOne() == null) continue;
            return group;
        }
        return null;
    }

    private int searchIdAliasLocal(int resourceId) {
        for (Set<PackageBlock> packageBlockSet : this.mLocalPackagesMap.values()) {
            for (PackageBlock packageBlock : packageBlockSet) {
                StagedAliasEntry stagedAliasEntry = packageBlock.searchByStagedResId(resourceId);
                if (stagedAliasEntry == null) continue;
                return stagedAliasEntry.getFinalizedResId();
            }
        }
        return 0;
    }

    private int searchIdAliasFramework(int resourceId) {
        for (Set<PackageBlock> packageBlockSet : this.mLocalPackagesMap.values()) {
            for (PackageBlock packageBlock : packageBlockSet) {
                StagedAliasEntry stagedAliasEntry = packageBlock.searchByStagedResId(resourceId);
                if (stagedAliasEntry == null) continue;
                return stagedAliasEntry.getFinalizedResId();
            }
        }
        return 0;
    }
}

