/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;

public class FileChannelInputStream
extends InputStream {
    private final FileChannel fileChannel;
    private final long totalLength;
    private long startOffset;
    private long position;
    private final byte[] buffer;
    private int bufferPosition;
    private int bufferLength;
    private boolean mAutoClosable;
    private boolean mIsClosed;
    private static final int DEFAULT_BUFFER_SIZE = 102400;

    public FileChannelInputStream(FileChannel fileChannel, long length, int bufferSize) throws IOException {
        this.fileChannel = fileChannel;
        this.totalLength = length;
        if (bufferSize <= 0) {
            bufferSize = 8;
        }
        if (length < (long)bufferSize) {
            bufferSize = (int)length;
        }
        this.buffer = new byte[bufferSize];
        this.bufferLength = bufferSize;
        this.bufferPosition = bufferSize;
        this.startOffset = fileChannel.position();
    }

    public FileChannelInputStream(FileChannel fileChannel, long length) throws IOException {
        this(fileChannel, length, 102400);
    }

    public FileChannelInputStream(File file, long length, int bufferSize) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ), length, bufferSize);
        this.mAutoClosable = true;
    }

    public FileChannelInputStream(File file) throws IOException {
        this(FileChannel.open(file.toPath(), StandardOpenOption.READ), file.length());
        this.mAutoClosable = true;
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        if (this.isFinished()) {
            return -1;
        }
        if (length == 0) {
            return 0;
        }
        this.loadBuffer();
        int result = 0;
        int read = this.readBuffer(bytes, offset, length);
        result += read;
        length -= read;
        offset += read;
        while (length > 0 && !this.isFinished()) {
            this.loadBuffer();
            read = this.readBuffer(bytes, offset, length);
            result += read;
            length -= read;
            offset += read;
        }
        return result;
    }

    private int readBuffer(byte[] bytes, int offset, int length) {
        int avail = this.bufferLength - this.bufferPosition;
        if (avail == 0) {
            return 0;
        }
        int read = length;
        if (read > avail) {
            read = avail;
        }
        System.arraycopy(this.buffer, this.bufferPosition, bytes, offset, read);
        this.bufferPosition += read;
        this.position += (long)read;
        return read;
    }

    private void loadBuffer() throws IOException {
        byte[] buffer = this.buffer;
        if (this.bufferPosition < this.bufferLength) {
            return;
        }
        int length = buffer.length;
        long available = this.totalLength - this.position;
        boolean is_last = false;
        if ((long)length > available) {
            length = (int)available;
            is_last = true;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer, 0, length);
        this.bufferLength = this.fileChannel.read(byteBuffer);
        this.bufferPosition = 0;
        if (is_last) {
            this.closeAuto();
        }
    }

    private boolean isFinished() throws IOException {
        boolean finished;
        boolean bl = finished = this.position >= this.totalLength;
        if (finished) {
            this.closeAuto();
        }
        return finished;
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int read = this.read(bytes);
        if (read < 0) {
            return read;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        long transferred = 0L;
        if (this.isFinished()) {
            return transferred;
        }
        while (!this.isFinished()) {
            this.loadBuffer();
            int offset = this.bufferPosition;
            int length = this.bufferLength - this.bufferPosition;
            if (length <= 0) break;
            out.write(this.buffer, offset, length);
            this.bufferPosition += length;
            this.position += (long)length;
            transferred += (long)length;
        }
        return transferred;
    }

    @Override
    public long skip(long amount) throws IOException {
        if (amount <= 0L) {
            return amount;
        }
        long remaining = amount;
        if ((remaining -= (long)this.skipBuffer((int)remaining)) == 0L) {
            return amount;
        }
        long availableChannel = this.totalLength - this.position;
        if (availableChannel > remaining) {
            availableChannel = remaining;
        }
        this.position += availableChannel;
        this.fileChannel.position(this.fileChannel.position() + availableChannel);
        return amount -= (remaining -= availableChannel);
    }

    private int skipBuffer(int amount) {
        int availableBuffer = this.bufferLength - this.bufferPosition;
        if (availableBuffer > amount) {
            availableBuffer = amount;
        }
        this.bufferPosition += availableBuffer;
        this.position += (long)availableBuffer;
        return availableBuffer;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public void setAutoClosable(boolean autoClosable) {
        this.mAutoClosable = autoClosable;
    }

    private void closeAuto() throws IOException {
        if (this.mAutoClosable && !this.mIsClosed) {
            this.mIsClosed = true;
            this.fileChannel.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeAuto();
    }

    @Override
    public void reset() throws IOException {
        this.position = 0L;
        this.bufferPosition = this.bufferLength;
        this.fileChannel.position(this.startOffset);
    }

    @Override
    public int available() {
        return (int)(this.totalLength - this.position);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readLimit) {
        if (readLimit < 0) {
            readLimit = 0;
        }
        this.startOffset = readLimit;
    }

    public String toString() {
        return this.position + " / " + this.totalLength;
    }

    public static byte[] read(File file, int length) throws IOException {
        FileChannelInputStream inputStream = new FileChannelInputStream(file, (long)length, length);
        inputStream.loadBuffer();
        inputStream.closeAuto();
        return inputStream.buffer;
    }
}

