/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.style;

import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.attribute.AttributeBag;
import com.reandroid.arsc.value.attribute.AttributeBagItem;
import com.reandroid.arsc.value.bag.BagItem;
import com.reandroid.common.EntryStore;

public class StyleBagItem
extends BagItem {
    private StyleBagItem(ResValueMap bagItem) {
        super(bagItem);
    }

    private StyleBagItem(ValueType valueType, int data) {
        super(valueType, data);
    }

    private StyleBagItem(StringItem str) {
        super(str);
    }

    public String getName() {
        if (this.mBagItem == null) {
            return null;
        }
        Entry block = this.mBagItem.getEntry();
        if (block == null) {
            return null;
        }
        char prefix = '\u0000';
        return block.buildResourceName(this.mBagItem.getName(), prefix, false);
    }

    public Entry getAttributeEntry(EntryStore entryStore) {
        if (this.mBagItem == null) {
            return null;
        }
        return entryStore.getEntryGroup(this.mBagItem.getName()).pickOne();
    }

    public int getNameId() {
        if (this.mBagItem == null) {
            return 0;
        }
        return this.mBagItem.getName();
    }

    public boolean hasAttributeValue() {
        return this.getValueType() == ValueType.ATTRIBUTE;
    }

    public boolean hasIntValue() {
        ValueType valueType = this.getValueType();
        return valueType == ValueType.DEC || valueType == ValueType.HEX;
    }

    public String getValueAsReference() {
        ValueType valueType = this.getValueType();
        if (valueType != ValueType.REFERENCE && valueType != ValueType.ATTRIBUTE) {
            throw new IllegalArgumentException("Not REF ValueType=" + (Object)((Object)valueType));
        }
        Entry entry = this.getBagItem().getEntry();
        if (entry == null) {
            return null;
        }
        char prefix = '@';
        boolean includeType = true;
        if (valueType == ValueType.ATTRIBUTE) {
            prefix = '?';
            includeType = false;
        }
        int id = this.getValue();
        return entry.buildResourceName(id, prefix, includeType);
    }

    public String decodeAttributeValue(AttributeBag attr, EntryStore entryStore) {
        if (!this.hasIntValue()) {
            return null;
        }
        return attr.decodeAttributeValue(entryStore, this.getValue());
    }

    public AttributeBagItem[] getFlagsOrEnum(AttributeBag attr) {
        if (!this.hasIntValue()) {
            return null;
        }
        return attr.searchValue(this.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<item name=\"");
        String name = this.getName();
        if (name == null) {
            name = HexUtil.toHex8("@0x", this.getNameId());
        }
        builder.append(name);
        builder.append("\">");
        if (this.hasStringValue()) {
            builder.append(this.getStringValue());
        }
        String val = null;
        if (this.hasReferenceValue() || this.hasAttributeValue()) {
            val = this.getValueAsReference();
        }
        if (val == null) {
            val = HexUtil.toHex8(this.getValue());
        }
        builder.append(val);
        builder.append("</item>");
        return builder.toString();
    }

    protected static StyleBagItem create(ResValueMap resValueMap) {
        if (resValueMap == null) {
            return null;
        }
        return new StyleBagItem(resValueMap);
    }

    public static StyleBagItem create(ValueType valueType, int value) {
        if (valueType == null || valueType == ValueType.STRING) {
            return null;
        }
        return new StyleBagItem(valueType, value);
    }

    protected static StyleBagItem copyOf(ResValueMap resValueMap) {
        ValueType valueType = resValueMap.getValueType();
        if (valueType == ValueType.STRING) {
            return new StyleBagItem(resValueMap.getDataAsPoolString());
        }
        return new StyleBagItem(valueType, resValueMap.getData());
    }

    public static StyleBagItem integer(int n) {
        return new StyleBagItem(ValueType.DEC, n);
    }

    public static StyleBagItem string(TableString str) {
        if (str == null) {
            return null;
        }
        return new StyleBagItem(str);
    }

    public static StyleBagItem reference(int resourceId) {
        return new StyleBagItem(ValueType.REFERENCE, resourceId);
    }

    public static StyleBagItem attribute(int resourceId) {
        return new StyleBagItem(ValueType.ATTRIBUTE, resourceId);
    }

    public static StyleBagItem encoded(EncodeResult encodeResult) {
        if (encodeResult == null) {
            return null;
        }
        return StyleBagItem.create(encodeResult.valueType, encodeResult.value);
    }

    public static StyleBagItem color(String color) {
        return StyleBagItem.encoded(ValueDecoder.encodeColor(color));
    }

    public static StyleBagItem dimensionOrFraction(String str) {
        return StyleBagItem.encoded(ValueDecoder.encodeDimensionOrFraction(str));
    }

    public static StyleBagItem createFloat(float n) {
        return new StyleBagItem(ValueType.FLOAT, Float.floatToIntBits(n));
    }

    public static StyleBagItem enumOrFlag(AttributeBag attr, String valueString) {
        return StyleBagItem.encoded(attr.encodeEnumOrFlagValue(valueString));
    }
}

