/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.style;

import com.reandroid.apk.xmlencoder.EncodeMaterials;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.bag.MapBag;
import com.reandroid.arsc.value.style.StyleBagItem;

public class StyleBag
extends MapBag<Integer, StyleBagItem> {
    private StyleBag(Entry entry) {
        super(entry);
    }

    public String getParentResourceName() {
        int id = this.getParentId();
        if (id == 0) {
            return null;
        }
        Entry entry = this.getEntry();
        if (entry == null) {
            return null;
        }
        return entry.buildResourceName(id, '@', true);
    }

    public int getParentId() {
        return this.getTableEntry().getParentId();
    }

    public void setParentId(int id) {
        this.getTableEntry().setParentId(id);
    }

    public int getResourceId() {
        Entry entry = this.getEntry();
        if (entry == null) {
            return 0;
        }
        return entry.getResourceId();
    }

    @Override
    protected StyleBagItem createBagItem(ResValueMap valueMap, boolean copied) {
        if (copied) {
            return StyleBagItem.copyOf(valueMap);
        }
        return StyleBagItem.create(valueMap);
    }

    @Override
    protected ResValueMap newKey(Integer attrId) {
        ResValueMap valueMap = new ResValueMap();
        valueMap.setParent(this.getMapArray());
        valueMap.setName(attrId);
        return valueMap;
    }

    @Override
    protected Integer getKeyFor(ResValueMap valueMap) {
        return valueMap.getName();
    }

    public static int resolve(EncodeMaterials materials, String name) {
        return materials.getAttributeBlock(name).getResourceId();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        String type = this.getTypeName();
        builder.append(type);
        builder.append(" name=\"");
        builder.append(this.getName());
        builder.append("\"");
        String parent = this.getParentResourceName();
        if (parent != null) {
            builder.append(" parent=\"");
            builder.append(parent);
            builder.append("\"");
        }
        builder.append("\">");
        for (StyleBagItem item : this.values()) {
            builder.append("\n    ");
            builder.append(item.toString());
        }
        builder.append("\n</");
        builder.append(type);
        builder.append(">");
        return builder.toString();
    }

    public static boolean isStyle(Entry entry) {
        StyleBag style = StyleBag.create(entry);
        if (style == null) {
            return false;
        }
        TableBlock tableBlock = entry.getPackageBlock().getTableBlock();
        if (tableBlock == null) {
            return false;
        }
        ResValueMap[] items = (ResValueMap[])style.getMapArray().getChildes();
        if (items.length == 0) {
            return false;
        }
        for (ResValueMap item : items) {
            if (item != null && tableBlock.search(item.getNameResourceID()) != null) continue;
            return false;
        }
        return true;
    }

    public static StyleBag create(Entry entry) {
        if (entry == null || !entry.isComplex()) {
            return null;
        }
        return new StyleBag(entry);
    }
}

