/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.plurals;

import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.bag.BagItem;
import com.reandroid.arsc.value.plurals.PluralsQuantity;
import java.util.List;

public class PluralsBagItem
extends BagItem {
    private PluralsBagItem(ResValueMap bagItem) {
        super(bagItem);
    }

    private PluralsBagItem(StringItem str) {
        super(str);
    }

    private PluralsBagItem(ValueType valueType, int data) {
        super(valueType, data);
    }

    public PluralsQuantity getQuantity() {
        if (this.mBagItem == null || this.mBagItem.getName() == 0) {
            return null;
        }
        return PluralsQuantity.valueOf(this.mBagItem);
    }

    public String getQualityString(ResConfig resConfig) {
        switch (this.getValueType()) {
            case STRING: {
                return this.getStringValue();
            }
            case REFERENCE: {
                TableBlock tableBlock;
                List<Entry> resolvedList;
                Entry entry = null;
                if (this.mBagItem != null) {
                    entry = this.mBagItem.getEntry();
                }
                if (entry == null) {
                    return null;
                }
                if (resConfig == null) {
                    resConfig = entry.getResConfig();
                }
                Entry stringRes = null;
                if (resConfig != null && (resolvedList = (tableBlock = entry.getPackageBlock().getTableBlock()).resolveReferenceWithConfig(this.getValue(), resConfig)).size() > 0) {
                    stringRes = resolvedList.get(0);
                }
                if (stringRes == null) {
                    return null;
                }
                ResValue resValue = stringRes.getResValue();
                if (resValue == null || resValue.getValueType() != ValueType.STRING) {
                    throw new IllegalArgumentException("Not a STR reference: " + this.formattedRefValue());
                }
                return resValue.getValueAsString();
            }
        }
        throw new IllegalArgumentException("Not STR/REFERENCE ValueType=" + (Object)((Object)this.getValueType()));
    }

    private String formattedRefValue() {
        return HexUtil.toHex8("@0x", this.getValue());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<item quantity=\"");
        builder.append((Object)this.getQuantity());
        builder.append("\">");
        if (this.hasStringValue()) {
            builder.append(this.getStringValue());
        } else {
            builder.append(this.formattedRefValue());
        }
        builder.append("</item>");
        return builder.toString();
    }

    protected static PluralsBagItem create(ResValueMap resValueMap) {
        if (resValueMap == null) {
            return null;
        }
        return new PluralsBagItem(resValueMap);
    }

    protected static PluralsBagItem copyOf(ResValueMap resValueMap) {
        ValueType valueType = resValueMap.getValueType();
        if (valueType == ValueType.STRING) {
            return new PluralsBagItem(resValueMap.getDataAsPoolString());
        }
        return new PluralsBagItem(valueType, resValueMap.getData());
    }

    public static PluralsBagItem string(TableString str) {
        if (str == null) {
            return null;
        }
        return new PluralsBagItem(str);
    }

    public static PluralsBagItem reference(int resourceId) {
        return new PluralsBagItem(ValueType.REFERENCE, resourceId);
    }
}

