/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.plurals;

import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.bag.MapBag;
import com.reandroid.arsc.value.plurals.PluralsBagItem;
import com.reandroid.arsc.value.plurals.PluralsQuantity;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class PluralsBag
extends MapBag<PluralsQuantity, PluralsBagItem> {
    private static final Set<ValueType> validTypes = new HashSet<ValueType>(Arrays.asList(ValueType.NULL, ValueType.STRING, ValueType.REFERENCE));

    private PluralsBag(Entry entry) {
        super(entry);
    }

    @Override
    protected PluralsBagItem createBagItem(ResValueMap valueMap, boolean copied) {
        if (copied) {
            return PluralsBagItem.copyOf(valueMap);
        }
        return PluralsBagItem.create(valueMap);
    }

    @Override
    protected ResValueMap newKey(PluralsQuantity key) {
        ResValueMap valueMap = new ResValueMap();
        valueMap.setParent(this.getMapArray());
        valueMap.setNameHigh((short)256);
        valueMap.setNameLow(key.getId());
        return valueMap;
    }

    @Override
    protected PluralsQuantity getKeyFor(ResValueMap valueMap) {
        return PluralsQuantity.valueOf(valueMap);
    }

    public String getQuantityString(PluralsQuantity quantity, ResConfig resConfig) {
        PluralsBagItem item = (PluralsBagItem)this.get((Object)quantity);
        if (item == null) {
            return null;
        }
        return item.getQualityString(resConfig);
    }

    public String getQuantityString(PluralsQuantity quantity) {
        return this.getQuantityString(quantity, null);
    }

    public void setQuantityString(PluralsQuantity quantity, String str) {
        if (quantity == null || str == null) {
            return;
        }
        this.put(quantity, PluralsBagItem.string((TableString)this.getStringPool().getOrCreate(str)));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        String type = this.getTypeName();
        builder.append(type);
        builder.append(" name=\"");
        builder.append(this.getName());
        builder.append("\">");
        for (PluralsBagItem pluralsBagItem : this.values()) {
            builder.append("\n    ");
            builder.append(pluralsBagItem.toString());
        }
        builder.append("\n</");
        builder.append(type);
        builder.append(">");
        return builder.toString();
    }

    public static boolean isPlurals(Entry entry) {
        PluralsBag plurals = PluralsBag.create(entry);
        if (plurals == null) {
            return false;
        }
        ResValueMap[] items = (ResValueMap[])plurals.getMapArray().getChildes();
        if (items.length == 0) {
            return false;
        }
        for (ResValueMap item : items) {
            if (item == null || !validTypes.contains((Object)item.getValueType())) {
                return false;
            }
            int name = item.getName();
            int high = name >> 16 & 0xFFFF;
            if (PluralsQuantity.valueOf(item) != null && high == 256) continue;
            return false;
        }
        return true;
    }

    public static PluralsBag create(Entry entry) {
        if (entry == null || !entry.isComplex()) {
            return null;
        }
        return new PluralsBag(entry);
    }
}

