/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.bag;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.bag.Bag;
import com.reandroid.arsc.value.bag.BagItem;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class MapBag<K, V extends BagItem>
extends AbstractMap<K, V>
implements Bag {
    protected final Entry entry;
    private int modCount = 0;

    protected MapBag(Entry entry) {
        this.entry = entry;
    }

    protected ResTableMapEntry getTableEntry() {
        return (ResTableMapEntry)this.entry.getTableEntry();
    }

    protected ResValueMapArray getMapArray() {
        return (ResValueMapArray)this.getTableEntry().getValue();
    }

    private void updateSize() {
        this.getTableEntry().setValuesCount(this.size());
        ++this.modCount;
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    protected abstract V createBagItem(ResValueMap var1, boolean var2);

    protected abstract ResValueMap newKey(K var1);

    protected abstract K getKeyFor(ResValueMap var1);

    protected TableStringPool getStringPool() {
        Entry entry = this.getEntry();
        if (entry == null) {
            return null;
        }
        PackageBlock pkg = entry.getPackageBlock();
        if (pkg == null) {
            return null;
        }
        TableBlock tableBlock = pkg.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        return tableBlock.getTableStringPool();
    }

    @Override
    public V remove(Object key) {
        ResValueMapArray array = this.getMapArray();
        for (ResValueMap item : (ResValueMap[])array.getChildes()) {
            if (!this.getKeyFor(item).equals(key)) continue;
            if (!array.remove(item)) {
                throw new IllegalStateException("Could not remove item");
            }
            this.updateSize();
            return this.createBagItem(item, true);
        }
        return null;
    }

    @Override
    public void clear() {
        this.getMapArray().clearChildes();
        this.updateSize();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        ResValueMapArray array = this.getMapArray();
        ResValueMap valueMap = null;
        for (ResValueMap item : (ResValueMap[])array.getChildes()) {
            if (!this.getKeyFor(item).equals(key)) continue;
            valueMap = item;
            break;
        }
        if (valueMap == null) {
            valueMap = this.newKey(key);
            array.add(valueMap);
            this.updateSize();
        }
        ((BagItem)value).copyTo(valueMap);
        return this.createBagItem(valueMap, false);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        LinkedHashSet<K> keys = new LinkedHashSet<K>(m.keySet());
        ResValueMapArray array = this.getMapArray();
        for (ResValueMap item : (ResValueMap[])array.getChildes()) {
            K currentKey = this.getKeyFor(item);
            if (!keys.remove(currentKey)) continue;
            BagItem src = (BagItem)m.get(currentKey);
            src.copyTo(item);
        }
        for (Object key : keys) {
            if (key == null) {
                throw new NullPointerException("Key is null");
            }
            ResValueMap item = this.newKey(key);
            array.add(item);
            BagItem src = (BagItem)m.get(key);
            src.copyTo(item);
        }
        this.updateSize();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private final Iterator<ResValueMap> iterator;
                private final int expectedModCount;
                {
                    this.iterator = MapBag.this.getMapArray().iterator();
                    this.expectedModCount = MapBag.this.modCount;
                }

                private void checkValidity() {
                    if (this.expectedModCount != MapBag.this.modCount) {
                        throw new ConcurrentModificationException("Iterator is no longer valid because the size has changed.");
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkValidity();
                    return this.iterator.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    this.checkValidity();
                    return new MapEntry(this.iterator.next());
                }
            };
        }

        @Override
        public int size() {
            return MapBag.this.getMapArray().childesCount();
        }
    }

    private class MapEntry
    implements Map.Entry<K, V> {
        private final ResValueMap item;

        private MapEntry(ResValueMap item) {
            this.item = item;
        }

        @Override
        public K getKey() {
            return MapBag.this.getKeyFor(this.item);
        }

        @Override
        public V getValue() {
            return MapBag.this.createBagItem(this.item, false);
        }

        @Override
        public V setValue(V v) {
            ((BagItem)v).copyTo(this.item);
            return this.getValue();
        }
    }
}

