/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.attribute;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueCoder;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.common.EntryStore;

public class AttributeBagItem {
    private final ResValueMap mBagItem;

    public AttributeBagItem(ResValueMap bagItem) {
        this.mBagItem = bagItem;
    }

    public int getData() {
        return this.getBagItem().getData();
    }

    public String getNameOrHex() {
        return this.getNameOrHex(null);
    }

    public String getNameOrHex(EntryStore entryStore) {
        String name = this.getName(entryStore);
        if (name == null) {
            name = ValueCoder.decodeUnknownResourceId(false, this.getBagItem().getNameResourceID());
        }
        return name;
    }

    public String getName() {
        return this.getName(null);
    }

    public String getName(EntryStore entryStore) {
        EntryGroup entryGroup;
        String name;
        EntryGroup entryGroup2;
        PackageBlock packageBlock;
        if (this.isType()) {
            return null;
        }
        ResValueMap item = this.getBagItem();
        int id = item.getName();
        Entry parentEntry = item.getEntry();
        if (parentEntry != null && (packageBlock = parentEntry.getPackageBlock()) != null && (entryGroup2 = packageBlock.getEntryGroup(id)) != null && (name = entryGroup2.getSpecName()) != null) {
            return name;
        }
        if (entryStore != null && (entryGroup = entryStore.getEntryGroup(id)) != null) {
            return entryGroup.getSpecName();
        }
        return null;
    }

    public ResValueMap getBagItem() {
        return this.mBagItem;
    }

    public AttributeType getType() {
        return this.getBagItem().getAttributeType();
    }

    public boolean isFormats() {
        return this.getType() == AttributeType.FORMATS;
    }

    public boolean isType() {
        return this.getType() != null;
    }

    public boolean contains(AttributeDataFormat dataFormat) {
        if (dataFormat == null || !this.isFormats()) {
            return false;
        }
        return dataFormat.matches(this.getBagItem().getData());
    }

    public boolean isEqualType(AttributeDataFormat typeFormat) {
        if (typeFormat == null || !this.isFormats()) {
            return false;
        }
        return typeFormat.getMask() == this.getBagItem().getData();
    }

    public AttributeDataFormat[] getDataFormats() {
        if (!this.isFormats()) {
            return null;
        }
        return AttributeDataFormat.decodeValueTypes(this.getBagItem().getData());
    }

    public boolean isEnum() {
        if (!this.isFormats()) {
            return false;
        }
        return AttributeDataFormat.ENUM.matches(this.getBagItem().getData());
    }

    public boolean isFlag() {
        if (!this.isFormats()) {
            return false;
        }
        return AttributeDataFormat.FLAG.matches(this.getBagItem().getData());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        ResValueMap item = this.getBagItem();
        builder.append(this.getNameOrHex());
        builder.append("=").append(HexUtil.toHex8(item.getData()));
        return builder.toString();
    }

    public static String toString(EntryStore entryStore, AttributeBagItem[] bagItems) {
        return AttributeBagItem.toString(entryStore, bagItems, false);
    }

    public static String toString(EntryStore entryStore, AttributeBagItem[] bagItems, boolean use_hex) {
        if (bagItems == null) {
            return null;
        }
        int len = bagItems.length;
        if (len == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        for (int i = 0; i < len; ++i) {
            String name;
            AttributeBagItem item = bagItems[i];
            if (item == null) continue;
            if (appendOnce) {
                builder.append("|");
            }
            if ((name = use_hex ? item.getNameOrHex(entryStore) : item.getName(entryStore)) == null) {
                return null;
            }
            builder.append(name);
            appendOnce = true;
        }
        if (appendOnce) {
            return builder.toString();
        }
        return null;
    }

    public static AttributeBagItem[] create(ResValueMap[] resValueMaps) {
        if (resValueMaps == null) {
            return null;
        }
        AttributeBagItem format = null;
        int len = resValueMaps.length;
        AttributeBagItem[] bagItems = new AttributeBagItem[len];
        for (int i = 0; i < len; ++i) {
            AttributeBagItem item;
            bagItems[i] = item = new AttributeBagItem(resValueMaps[i]);
            if (format != null || AttributeType.FORMATS != item.getType()) continue;
            format = item;
        }
        if (format != null) {
            return bagItems;
        }
        return null;
    }
}

