/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.array;

import com.reandroid.arsc.coder.EncodeResult;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.arsc.value.bag.BagItem;

public class ArrayBagItem
extends BagItem {
    private ArrayBagItem(ResValueMap valueMap) {
        super(valueMap);
    }

    private ArrayBagItem(StringItem str) {
        super(str);
    }

    private ArrayBagItem(ValueType valueType, int value) {
        super(valueType, value);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<item>");
        if (this.hasStringValue()) {
            builder.append(this.getStringValue());
        } else {
            builder.append(HexUtil.toHex8(this.getValue()));
        }
        builder.append("</item>");
        return builder.toString();
    }

    protected static ArrayBagItem create(ResValueMap valueMap) {
        if (valueMap == null) {
            return null;
        }
        return new ArrayBagItem(valueMap);
    }

    public static ArrayBagItem create(ValueType valueType, int value) {
        if (valueType == null || valueType == ValueType.STRING) {
            return null;
        }
        return new ArrayBagItem(valueType, value);
    }

    protected static ArrayBagItem copyOf(ResValueMap resValueMap) {
        ValueType valueType = resValueMap.getValueType();
        if (valueType == ValueType.STRING) {
            return new ArrayBagItem(resValueMap.getDataAsPoolString());
        }
        return new ArrayBagItem(valueType, resValueMap.getData());
    }

    public static ArrayBagItem encoded(EncodeResult encodeResult) {
        if (encodeResult == null) {
            return null;
        }
        return ArrayBagItem.create(encodeResult.valueType, encodeResult.value);
    }

    public static ArrayBagItem integer(int n) {
        return ArrayBagItem.create(ValueType.DEC, n);
    }

    public static ArrayBagItem string(TableString str) {
        if (str == null) {
            return null;
        }
        return new ArrayBagItem(str);
    }

    public static ArrayBagItem reference(int resourceId) {
        return ArrayBagItem.create(ValueType.REFERENCE, resourceId);
    }
}

