/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value.array;

import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.array.ArrayBagItem;
import com.reandroid.arsc.value.bag.Bag;
import java.util.AbstractList;
import java.util.RandomAccess;

public class ArrayBag
extends AbstractList<ArrayBagItem>
implements Bag,
RandomAccess {
    private final Entry entry;

    private ArrayBag(Entry entry) {
        this.entry = entry;
    }

    private ResTableMapEntry getTableEntry() {
        return (ResTableMapEntry)this.entry.getTableEntry();
    }

    private ResValueMapArray getMapArray() {
        return (ResValueMapArray)this.getTableEntry().getValue();
    }

    private void updateStructure(int regenStart) {
        this.getTableEntry().setValuesCount(this.size());
        ++this.modCount;
        if (regenStart < 1) {
            return;
        }
        ResValueMapArray array = this.getMapArray();
        for (int i = regenStart; i < array.childesCount(); ++i) {
            this.setIndex((ResValueMap)array.get(i), i);
        }
    }

    @Override
    public Entry getEntry() {
        return this.entry;
    }

    public ArrayBagItem[] getBagItems() {
        return this.toArray(new ArrayBagItem[0]);
    }

    @Override
    public int size() {
        return this.getMapArray().childesCount();
    }

    @Override
    public ArrayBagItem get(int i) {
        return ArrayBagItem.create((ResValueMap)this.getMapArray().get(i));
    }

    @Override
    public ArrayBagItem set(int index, ArrayBagItem value) {
        ArrayBagItem target = this.get(index);
        value.copyTo(target.getBagItem());
        return target;
    }

    private void setIndex(ResValueMap valueMap, int index) {
        valueMap.setName(0x1000001 + index);
    }

    @Override
    public void add(int index, ArrayBagItem value) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        ResValueMap valueMap = new ResValueMap();
        this.setIndex(valueMap, index);
        this.getMapArray().insertItem(index, valueMap);
        value.copyTo(valueMap);
        this.updateStructure(index);
    }

    @Override
    public ArrayBagItem remove(int index) {
        ResValueMapArray array = this.getMapArray();
        ResValueMap target = ((ResValueMap[])array.getChildes())[index];
        array.remove(target);
        this.updateStructure(index);
        return ArrayBagItem.copyOf(target);
    }

    @Override
    public void clear() {
        this.getMapArray().clearChildes();
        this.updateStructure(-1);
    }

    @Override
    public String toString() {
        ArrayBagItem[] allItems;
        StringBuilder builder = new StringBuilder();
        builder.append("<");
        String type = this.getTypeName();
        builder.append(type);
        builder.append(" name=\"");
        builder.append(this.getName());
        builder.append("\">");
        for (ArrayBagItem allItem : allItems = this.getBagItems()) {
            builder.append("\n    ");
            builder.append(allItem.toString());
        }
        builder.append("\n</");
        builder.append(type);
        builder.append(">");
        return builder.toString();
    }

    public static boolean isArray(Entry entry) {
        ArrayBag array = ArrayBag.create(entry);
        if (array == null) {
            return false;
        }
        ResTableMapEntry tableEntry = array.getTableEntry();
        if (tableEntry.getParentId() != 0) {
            return false;
        }
        ResValueMap[] items = tableEntry.listResValueMap();
        if (items.length == 0) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            ResValueMap resValueMap = items[i];
            int name = resValueMap.getName();
            int high = name >> 16 & 0xFFFF;
            if (high != 256) {
                return false;
            }
            int low = name & 0xFFFF;
            if (low == i + 1) continue;
            return false;
        }
        return true;
    }

    public static ArrayBag create(Entry entry) {
        if (entry == null || !entry.isComplex()) {
            return null;
        }
        return new ArrayBag(entry);
    }
}

