/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

public enum ValueType {
    NULL(0, ""),
    REFERENCE(1, "reference"),
    ATTRIBUTE(2, "reference"),
    FLOAT(4, "float"),
    DIMENSION(5, "dimension"),
    FRACTION(6, "fraction"),
    DEC(16, "integer"),
    HEX(17, "integer"),
    BOOLEAN(18, "bool"),
    COLOR_ARGB8(28, "color"),
    COLOR_RGB8(29, "color"),
    COLOR_ARGB4(30, "color"),
    COLOR_RGB4(31, "color"),
    STRING(3, "string"),
    DYNAMIC_REFERENCE(7, "reference"),
    DYNAMIC_ATTRIBUTE(8, "reference");

    private final byte mByte;
    private final String typeName;

    private ValueType(byte b, String typeName) {
        this.mByte = b;
        this.typeName = typeName;
    }

    public byte getByte() {
        return this.mByte;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean isColor() {
        return this == COLOR_ARGB8 || this == COLOR_RGB8 || this == COLOR_ARGB4 || this == COLOR_RGB4;
    }

    public boolean isInteger() {
        return this == DEC || this == HEX;
    }

    public boolean isReference() {
        return this == REFERENCE || this == ATTRIBUTE || this == DYNAMIC_REFERENCE || this == DYNAMIC_ATTRIBUTE;
    }

    public static ValueType valueOf(byte b) {
        ValueType[] all;
        for (ValueType vt : all = ValueType.values()) {
            if (vt.mByte != b) continue;
            return vt;
        }
        return null;
    }

    public static ValueType fromName(String name) {
        ValueType[] all;
        if (name == null) {
            return null;
        }
        name = name.toUpperCase();
        for (ValueType vt : all = ValueType.values()) {
            if (!name.equals(vt.name())) continue;
            return vt;
        }
        return null;
    }
}

