/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.MainChunk;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.ParentChunk;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.ReferenceBlock;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.pool.StringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.Value;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.Objects;

public abstract class ValueItem
extends BlockItem
implements Value,
JSONConvert<JSONObject> {
    private ReferenceItem mStringReference;
    private final int sizeOffset;
    private static final int OFFSET_SIZE = 0;
    private static final int OFFSET_RES0 = 2;
    private static final int OFFSET_TYPE = 3;
    private static final int OFFSET_DATA = 4;
    public static final String NAME_data = "data";
    public static final String NAME_value_type = "value_type";

    public ValueItem(int bytesLength, int sizeOffset) {
        super(bytesLength);
        this.sizeOffset = sizeOffset;
        this.writeSize();
    }

    public boolean isUndefined() {
        return this.getValueType() == ValueType.NULL && this.getData() == 0;
    }

    public Entry resolve(int resourceId) {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        Entry entry = packageBlock.getAnyEntry(resourceId);
        if (entry != null) {
            return entry;
        }
        TableBlock tableBlock = packageBlock.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        return tableBlock.getAnyEntry(resourceId);
    }

    public String buildReference(Entry entry, ValueType referenceType, boolean addType) {
        String packageName;
        if (entry == null) {
            return null;
        }
        PackageBlock packageBlock = entry.getPackageBlock();
        PackageBlock myPackageBlock = this.getPackageBlock();
        StringBuilder builder = new StringBuilder();
        if (referenceType == ValueType.REFERENCE || referenceType == ValueType.DYNAMIC_REFERENCE) {
            builder.append('@');
        } else if (referenceType == ValueType.ATTRIBUTE || referenceType == ValueType.DYNAMIC_ATTRIBUTE) {
            builder.append('?');
        }
        if (!(packageBlock == myPackageBlock || packageBlock == null || myPackageBlock == null || (packageName = packageBlock.getName()).equals(myPackageBlock.getName()) && packageBlock.getId() == myPackageBlock.getId())) {
            builder.append(packageName);
            builder.append(':');
        }
        if (addType) {
            builder.append(entry.getTypeName());
            builder.append('/');
        }
        builder.append(entry.getName());
        return builder.toString();
    }

    public PackageBlock getPackageBlock() {
        ParentChunk parentChunk = this.getParentChunk();
        if (parentChunk != null) {
            return parentChunk.getPackageBlock();
        }
        return null;
    }

    void linkTableStrings(TableStringPool tableStringPool) {
        if (this.getValueType() == ValueType.STRING) {
            this.linkStringReference(tableStringPool);
        }
    }

    public void onRemoved() {
        this.unLinkStringReference();
    }

    protected void onDataChanged() {
    }

    public void refresh() {
        this.writeSize();
    }

    byte getRes0() {
        return this.getBytesInternal()[this.sizeOffset + 2];
    }

    public byte getType() {
        return this.getBytesInternal()[this.sizeOffset + 3];
    }

    public void setType(byte type) {
        if (type == this.getType()) {
            return;
        }
        byte[] bts = this.getBytesInternal();
        int offset = this.sizeOffset + 3;
        byte old = bts[offset];
        bts[offset] = type;
        this.onTypeChanged(old, type);
        this.onDataChanged();
    }

    public int getSize() {
        return 0xFFFF & ValueItem.getShort(this.getBytesInternal(), this.sizeOffset + 0);
    }

    public void setSize(int size) {
        size = this.sizeOffset + size;
        this.setBytesLength(size, false);
        this.writeSize();
    }

    private void writeSize() {
        int offset = this.sizeOffset;
        int size = this.countBytes() - offset;
        ValueItem.putShort(this.getBytesInternal(), offset + 0, (short)size);
    }

    protected void onDataLoaded() {
        if (this.getValueType() == ValueType.STRING) {
            this.linkStringReference();
        } else {
            this.unLinkStringReference();
        }
    }

    @Override
    public ValueType getValueType() {
        return ValueType.valueOf(this.getType());
    }

    @Override
    public void setValueType(ValueType valueType) {
        byte type = 0;
        if (valueType != null) {
            type = valueType.getByte();
        }
        this.setType(type);
    }

    @Override
    public int getData() {
        return ValueItem.getInteger(this.getBytesInternal(), this.sizeOffset + 4);
    }

    @Override
    public void setData(int data) {
        byte[] bts = this.getBytesInternal();
        int old = ValueItem.getInteger(bts, this.sizeOffset + 4);
        if (old == data) {
            return;
        }
        this.unLinkStringReference();
        ValueItem.putInteger(bts, this.sizeOffset + 4, data);
        if (ValueType.STRING == this.getValueType()) {
            this.linkStringReference();
        }
        this.onDataChanged();
    }

    public StringItem getDataAsPoolString() {
        if (this.getValueType() != ValueType.STRING) {
            return null;
        }
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            return null;
        }
        return stringPool.get(this.getData());
    }

    private void onTypeChanged(byte old, byte type) {
        byte typeString = ValueType.STRING.getByte();
        if (old == typeString) {
            this.unLinkStringReference();
        } else if (type == typeString) {
            this.linkStringReference();
        }
    }

    private void linkStringReference() {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null || stringPool.isStringLinkLocked()) {
            return;
        }
        this.linkStringReference(stringPool);
    }

    private void linkStringReference(StringPool<?> stringPool) {
        Object tableString = stringPool.get(this.getData());
        if (tableString == null) {
            this.unLinkStringReference();
            return;
        }
        ReferenceBlock<ValueItem> stringReference = this.mStringReference;
        if (stringReference != null) {
            this.unLinkStringReference();
        }
        this.mStringReference = stringReference = new ReferenceBlock<ValueItem>(this, this.sizeOffset + 4);
        ((StringItem)tableString).addReference(stringReference);
    }

    private void unLinkStringReference() {
        ReferenceItem stringReference = this.mStringReference;
        if (stringReference == null) {
            return;
        }
        this.mStringReference = null;
        this.onUnlinkDataString(stringReference);
    }

    protected void onUnlinkDataString(ReferenceItem referenceItem) {
        StringPool<?> stringPool = this.getStringPool();
        if (stringPool == null) {
            return;
        }
        stringPool.removeReference(referenceItem);
    }

    public StringPool<?> getStringPool() {
        for (Block parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof MainChunk)) continue;
            return ((MainChunk)((Object)parent)).getStringPool();
        }
        return null;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        int readSize = this.initializeBytes(reader);
        super.onReadBytes(reader);
        if (readSize < 8) {
            this.setBytesLength(this.sizeOffset + 8, false);
            this.writeSize();
        }
    }

    private int initializeBytes(BlockReader reader) throws IOException {
        int readSize;
        int position = reader.getPosition();
        int offset = this.sizeOffset;
        reader.offset(offset);
        int size = readSize = reader.readUnsignedShort();
        if (size < 8 && reader.available() >= 8) {
            size = 8;
        }
        reader.seek(position);
        this.setBytesLength(offset + size, false);
        return readSize;
    }

    @Override
    public String getValueAsString() {
        StringItem stringItem = this.getDataAsPoolString();
        if (stringItem != null) {
            String value = stringItem.getHtml();
            if (value == null) {
                value = "";
            }
            return value;
        }
        return null;
    }

    public void setValueAsString(String str) {
        if (this.getValueType() == ValueType.STRING && Objects.equals(str, this.getValueAsString())) {
            return;
        }
        if (str == null) {
            str = "";
        }
        Object stringItem = this.getStringPool().getOrCreate(str);
        this.setData(((Block)stringItem).getIndex());
        this.setValueType(ValueType.STRING);
    }

    public boolean getValueAsBoolean() {
        return this.getData() != 0;
    }

    public void setValueAsBoolean(boolean val) {
        this.setValueType(ValueType.BOOLEAN);
        int data = val ? -1 : 0;
        this.setData(data);
    }

    public void setTypeAndData(ValueType valueType, int data) {
        this.setData(data);
        this.setValueType(valueType);
    }

    public void merge(ValueItem valueItem) {
        if (valueItem == null || valueItem == this) {
            return;
        }
        this.setSize(valueItem.getSize());
        ValueType coming = valueItem.getValueType();
        if (coming == ValueType.STRING) {
            this.setValueAsString(valueItem.getValueAsString());
        } else {
            this.setTypeAndData(coming, valueItem.getData());
        }
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        ValueType valueType = this.getValueType();
        jsonObject.put(NAME_value_type, valueType.name());
        if (valueType == ValueType.STRING) {
            jsonObject.put(NAME_data, this.getValueAsString());
        } else if (valueType == ValueType.BOOLEAN) {
            jsonObject.put(NAME_data, this.getValueAsBoolean());
        } else {
            jsonObject.put(NAME_data, this.getData());
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ValueType valueType = ValueType.fromName(json.getString(NAME_value_type));
        if (valueType == ValueType.STRING) {
            this.setValueAsString(json.optString(NAME_data, ""));
        } else if (valueType == ValueType.BOOLEAN) {
            this.setValueAsBoolean(json.getBoolean(NAME_data));
        } else {
            this.setValueType(valueType);
            this.setData(json.getInt(NAME_data));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int size = this.getSize();
        if (size != 8) {
            builder.append("size=").append(this.getSize());
            builder.append(", ");
        }
        builder.append("type=");
        ValueType valueType = this.getValueType();
        if (valueType != null) {
            builder.append((Object)valueType);
        } else {
            builder.append(HexUtil.toHex2(this.getType()));
        }
        builder.append(", data=");
        int data = this.getData();
        if (valueType == ValueType.STRING) {
            StringItem tableString = this.getDataAsPoolString();
            if (tableString != null) {
                builder.append(tableString.getHtml());
            } else {
                builder.append(HexUtil.toHex8(data));
            }
        } else {
            builder.append(HexUtil.toHex8(data));
        }
        return builder.toString();
    }
}

