/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.item.ByteArray;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;

public class StagedAliasEntry
extends ByteArray
implements JSONConvert<JSONObject> {
    public static final String NAME_staged_resource_id = "staged_resource_id";
    public static final String NAME_finalized_resource_id = "finalized_resource_id";

    public StagedAliasEntry() {
        super(8);
    }

    public boolean isEqual(StagedAliasEntry other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getStagedResId() == other.getStagedResId() && this.getFinalizedResId() == other.getFinalizedResId();
    }

    public int getStagedResId() {
        return this.getInteger(0);
    }

    public void setStagedResId(int id) {
        this.putInteger(0, id);
    }

    public int getFinalizedResId() {
        return this.getInteger(4);
    }

    public void setFinalizedResId(int id) {
        this.putInteger(4, id);
    }

    @Override
    public String toString() {
        return "stagedResId=" + HexUtil.toHex8(this.getStagedResId()) + ", finalizedResId=" + HexUtil.toHex8(this.getFinalizedResId());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_staged_resource_id, this.getStagedResId());
        jsonObject.put(NAME_finalized_resource_id, this.getFinalizedResId());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setStagedResId(json.getInt(NAME_staged_resource_id));
        this.setFinalizedResId(json.getInt(NAME_finalized_resource_id));
    }
}

