/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.coder.ValueDecoder;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.AttributeValue;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ValueItem;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONObject;

public class ResValueMap
extends ValueItem
implements AttributeValue {
    private static final int OFFSET_NAME = 0;
    private static final int OFFSET_SIZE = 4;
    public static final String NAME_name = "name";

    public ResValueMap() {
        super(12, 4);
    }

    public String decodeData() {
        String value = this.decodeDataAsAttrFormats();
        if (value != null) {
            return value;
        }
        ValueType valueType = this.getValueType();
        if (valueType == ValueType.STRING) {
            return this.getValueAsString();
        }
        int data = this.getData();
        if (AttributeDataFormat.REFERENCE.contains(valueType)) {
            Entry entry = this.resolve(data);
            if (entry == null) {
                return HexUtil.toHex8("@0x", data);
            }
            return this.buildReference(entry, valueType, true);
        }
        return ValueDecoder.decode(valueType, data);
    }

    private String decodeDataAsAttrFormats() {
        AttributeType attributeType = this.getAttributeType();
        if (attributeType != AttributeType.FORMATS) {
            return null;
        }
        return AttributeDataFormat.toString(AttributeDataFormat.decodeValueTypes(this.getData()));
    }

    public String decodeName() {
        AttributeType attributeType = this.getAttributeType();
        if (attributeType != null) {
            return attributeType.getName();
        }
        Entry entry = this.resolveName();
        return this.buildReference(entry, null, false);
    }

    @Override
    public Entry resolveName() {
        return this.resolve(this.getNameResourceID());
    }

    public AttributeType getAttributeType() {
        return AttributeType.valueOf(this.getNameResourceID());
    }

    public void setAttributeType(AttributeType attributeType) {
        this.setNameResourceID(attributeType.getId());
    }

    public AttributeDataFormat[] getAttributeTypeFormats() {
        AttributeType attributeType = this.getAttributeType();
        if (attributeType != AttributeType.FORMATS) {
            return null;
        }
        return AttributeDataFormat.decodeValueTypes(this.getData());
    }

    public void addAttributeTypeFormats(AttributeDataFormat[] formats) {
        if (formats == null) {
            return;
        }
        int data = this.getData() | AttributeDataFormat.sum(formats);
        this.setData(data);
    }

    public void addAttributeTypeFormat(AttributeDataFormat format) {
        if (format == null) {
            return;
        }
        int data = this.getData() | format.getMask();
        this.setData(data);
    }

    public Entry getEntry() {
        return this.getParent(Entry.class);
    }

    @Override
    public PackageBlock getParentChunk() {
        Entry entry = this.getEntry();
        if (entry != null) {
            return entry.getPackageBlock();
        }
        return null;
    }

    public ResTableMapEntry getParentMapEntry() {
        return this.getParentInstance(ResTableMapEntry.class);
    }

    public int getName() {
        return ResValueMap.getInteger(this.getBytesInternal(), 0);
    }

    public void setName(int name) {
        ResValueMap.putInteger(this.getBytesInternal(), 0, name);
    }

    @Override
    public int getNameResourceID() {
        return this.getName();
    }

    @Override
    public void setNameResourceID(int resourceId) {
        this.setName(resourceId);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        if (jsonObject == null) {
            return null;
        }
        jsonObject.put(NAME_name, this.getName());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.setName(json.getInt(NAME_name));
    }

    public void setNameHigh(short val) {
        int name = this.getName() & 0xFFFF;
        name = (val & 0xFFFF) << 16 | name;
        this.setName(name);
    }

    public void setNameLow(short val) {
        int name = this.getName() & 0xFFFF0000;
        name = val & 0xFFFF | name;
        this.setName(name);
    }

    public void setDataHigh(short val) {
        int data = this.getData() & 0xFFFF;
        data = (val & 0xFFFF) << 16 | data;
        this.setData(data);
    }

    public void setDataLow(short val) {
        int data = this.getData() & 0xFFFF0000;
        data = val & 0xFFFF | data;
        this.setData(data);
    }

    @Override
    public void merge(ValueItem valueItem) {
        if (valueItem == this || !(valueItem instanceof ResValueMap)) {
            return;
        }
        ResValueMap resValueMap = (ResValueMap)valueItem;
        super.merge(resValueMap);
        this.setName(resValueMap.getName());
    }

    @Override
    public String toString() {
        String name = this.decodeName();
        String data = this.decodeData();
        if (name != null && data != null) {
            return name + "=\"" + data + "\"";
        }
        return "name=" + HexUtil.toHex8(this.getName()) + ", " + super.toString();
    }
}

