/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.FixedLengthString;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.io.OutputStream;

public class LibraryInfo
extends Block
implements JSONConvert<JSONObject> {
    private final IntegerItem mPackageId = new IntegerItem();
    private final FixedLengthString mPackageName = new FixedLengthString(256);

    public LibraryInfo() {
        this.mPackageId.setIndex(0);
        this.mPackageId.setParent(this);
        this.mPackageName.setIndex(1);
        this.mPackageName.setParent(this);
    }

    public int getPackageId() {
        return this.mPackageId.get();
    }

    public void setPackageId(int id) {
        this.mPackageId.set(id);
    }

    public String getPackageName() {
        return this.mPackageName.get();
    }

    public void setPackageName(String packageName) {
        this.mPackageName.set(packageName);
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return LibraryInfo.addBytes(this.mPackageId.getBytes(), this.mPackageName.getBytes());
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.mPackageId.countBytes() + this.mPackageName.countBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        this.mPackageId.onCountUpTo(counter);
        this.mPackageName.onCountUpTo(counter);
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        int result = this.mPackageId.writeBytes(stream);
        return result += this.mPackageName.writeBytes(stream);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        this.mPackageId.readBytes(reader);
        this.mPackageName.readBytes(reader);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getPackageId());
        jsonObject.put("name", this.getPackageName());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setPackageId(json.getInt("id"));
        this.setPackageName(json.getString("name"));
    }

    public void merge(LibraryInfo info) {
        if (info == null || info == this) {
            return;
        }
        if (this.getPackageId() != info.getPackageId()) {
            throw new IllegalArgumentException("Can not add different id libraries: " + this.getPackageId() + "!=" + info.getPackageId());
        }
        this.setPackageName(info.getPackageName());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LIBRARY{");
        builder.append(HexUtil.toHex2((byte)this.getPackageId()));
        builder.append(':');
        String name = this.getPackageName();
        if (name == null) {
            name = "NULL";
        }
        builder.append(name);
        builder.append('}');
        return builder.toString();
    }
}

