/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.array.EntryArray;
import com.reandroid.arsc.array.ResValueMapArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.BlockCounter;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.SpecFlag;
import com.reandroid.arsc.item.SpecString;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.SpecStringPool;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.util.HexUtil;
import com.reandroid.arsc.value.CompoundEntry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.arsc.value.ResTableEntry;
import com.reandroid.arsc.value.ResTableMapEntry;
import com.reandroid.arsc.value.ResValue;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.arsc.value.ValueType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.io.OutputStream;

public class Entry
extends Block
implements JSONConvert<JSONObject> {
    private TableEntry<?, ?> mTableEntry;
    private IntegerItem mNullSpecReference;
    public static final String NAME_id = "id";

    public void linkTableStringsInternal(TableStringPool tableStringPool) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        tableEntry.linkTableStringsInternal(tableStringPool);
    }

    public void linkSpecStringsInternal(SpecStringPool specStringPool) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        Object header = tableEntry.getHeader();
        ((ValueHeader)header).linkSpecStringsInternal(specStringPool);
    }

    public ResValue getResValue() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry instanceof ResTableEntry) {
            return (ResValue)((ResTableEntry)tableEntry).getValue();
        }
        return null;
    }

    public ResValueMapArray getResValueMapArray() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry instanceof ResTableMapEntry) {
            return (ResValueMapArray)((ResTableMapEntry)tableEntry).getValue();
        }
        return null;
    }

    public SpecFlag getSpecFlag() {
        SpecBlock specBlock = this.getSpecBlock();
        if (specBlock == null) {
            return null;
        }
        return specBlock.getSpecFlag(this.getId());
    }

    public void ensureComplex(boolean isComplex) {
        this.ensureTableEntry(isComplex);
    }

    public int getId() {
        int id = this.getIndex();
        EntryArray entryArray = this.getParentInstance(EntryArray.class);
        if (entryArray != null) {
            id = entryArray.getEntryId(id);
        }
        return id;
    }

    public String getName() {
        SpecString specString = this.getSpecString();
        if (specString != null) {
            return specString.get();
        }
        return null;
    }

    public String getTypeName() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getTypeName();
        }
        return null;
    }

    public int getResourceId() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return 0;
        }
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock == null) {
            return 0;
        }
        return packageBlock.getId() << 24 | typeBlock.getId() << 16 | this.getId();
    }

    public int getSpecReference() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry == null) {
            return 0;
        }
        return ((ValueHeader)tableEntry.getHeader()).getKey();
    }

    public TypeString getTypeString() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getTypeString();
        }
        return null;
    }

    public boolean isDefault() {
        ResConfig resConfig = this.getResConfig();
        if (resConfig != null) {
            return resConfig.isDefault();
        }
        return false;
    }

    public void setSpecReference(StringItem specReference) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry == null) {
            return;
        }
        ((ValueHeader)tableEntry.getHeader()).setKey(specReference);
    }

    public void setSpecReference(SpecString specString) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            ((ValueHeader)tableEntry.getHeader()).setKey(specString);
            this.unlinkNullSpecString();
            return;
        }
        this.linkNullSpecString(specString);
    }

    public void setSpecReference(int ref) {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry == null) {
            this.linkNullSpecString(ref);
            return;
        }
        this.unlinkNullSpecString();
        ((ValueHeader)tableEntry.getHeader()).setKey(ref);
    }

    private void linkNullSpecString(int ref) {
        if (ref < 0) {
            this.unlinkNullSpecString();
            return;
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool == null) {
            this.unlinkNullSpecString();
            return;
        }
        this.linkNullSpecString((SpecString)specStringPool.get(ref));
    }

    private void linkNullSpecString(SpecString specString) {
        if (specString == null) {
            this.unlinkNullSpecString();
            return;
        }
        IntegerItem nullReference = this.mNullSpecReference;
        if (nullReference != null && nullReference.get() == specString.getIndex()) {
            return;
        }
        this.unlinkNullSpecString();
        nullReference = new IntegerItem();
        nullReference.setParent(this);
        nullReference.setIndex(1);
        nullReference.set(specString.getIndex());
        specString.addReference(nullReference);
        this.mNullSpecReference = nullReference;
    }

    private void unlinkNullSpecString() {
        IntegerItem nullReference = this.mNullSpecReference;
        if (nullReference == null) {
            return;
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool != null) {
            specStringPool.removeReference(nullReference);
        }
        nullReference.setParent(null);
        nullReference.setIndex(-1);
        this.mNullSpecReference = null;
    }

    private SpecStringPool getSpecStringPool() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getSpecStringPool();
        }
        return null;
    }

    private Entry searchEntry(int resourceId) {
        if (resourceId == this.getResourceId()) {
            return this;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        TableBlock tableBlock = packageBlock.getTableBlock();
        if (tableBlock == null) {
            return null;
        }
        EntryGroup entryGroup = tableBlock.search(resourceId);
        if (entryGroup != null) {
            return entryGroup.pickOne();
        }
        return null;
    }

    public ResValue setValueAsRaw(ValueType valueType, int data) {
        TableEntry<?, ?> tableEntry = this.ensureTableEntry(false);
        ResValue resValue = (ResValue)tableEntry.getValue();
        resValue.setTypeAndData(valueType, data);
        return resValue;
    }

    public ResValue setValueAsBoolean(boolean val) {
        int data = val ? -1 : 0;
        return this.setValueAsRaw(ValueType.BOOLEAN, data);
    }

    public ResValue setValueAsReference(int resourceId) {
        return this.setValueAsRaw(ValueType.REFERENCE, resourceId);
    }

    public ResValue setValueAsString(String str) {
        TableEntry<?, ?> tableEntry = this.ensureTableEntry(false);
        ResValue resValue = (ResValue)tableEntry.getValue();
        resValue.setValueAsString(str);
        return resValue;
    }

    public SpecString getSpecString() {
        int ref;
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry == null) {
            IntegerItem nullSpecReference = this.mNullSpecReference;
            if (nullSpecReference == null) {
                return null;
            }
            ref = nullSpecReference.get();
        } else {
            ref = ((ValueHeader)tableEntry.getHeader()).getKey();
        }
        SpecStringPool specStringPool = this.getSpecStringPool();
        if (specStringPool == null) {
            return null;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock == null) {
            return null;
        }
        return (SpecString)specStringPool.get(ref);
    }

    public ResConfig getResConfig() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock != null) {
            return typeBlock.getResConfig();
        }
        return null;
    }

    public SpecBlock getSpecBlock() {
        TypeBlock typeBlock = this.getTypeBlock();
        if (typeBlock == null) {
            return null;
        }
        SpecTypePair specTypePair = typeBlock.getParentSpecTypePair();
        if (specTypePair == null) {
            return null;
        }
        return specTypePair.getSpecBlock();
    }

    public TypeBlock getTypeBlock() {
        return this.getParent(TypeBlock.class);
    }

    private String getPackageName() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            return packageBlock.getName();
        }
        return null;
    }

    public PackageBlock getPackageBlock() {
        return this.getParent(PackageBlock.class);
    }

    private TableEntry<?, ?> ensureTableEntry(boolean is_complex) {
        boolean is_correct_type;
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        boolean bl = is_correct_type = is_complex && tableEntry instanceof ResTableMapEntry || !is_complex && tableEntry instanceof ResTableEntry;
        if (tableEntry == null || !is_correct_type) {
            tableEntry = this.createTableEntry(is_complex);
            this.setTableEntry(tableEntry);
        }
        return tableEntry;
    }

    public TableEntry<?, ?> getTableEntry() {
        return this.mTableEntry;
    }

    public ValueHeader getHeader() {
        TableEntry<?, ?> tableEntry = this.getTableEntry();
        if (tableEntry != null) {
            return tableEntry.getHeader();
        }
        return null;
    }

    @Override
    public boolean isNull() {
        return this.getTableEntry() == null;
    }

    @Override
    public void setNull(boolean is_null) {
        if (is_null) {
            this.setTableEntry(null);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.isNull()) {
            return null;
        }
        return this.getTableEntry().getBytes();
    }

    @Override
    public int countBytes() {
        if (this.isNull()) {
            return 0;
        }
        return this.getTableEntry().countBytes();
    }

    @Override
    public void onCountUpTo(BlockCounter counter) {
        if (counter.FOUND) {
            return;
        }
        if (counter.END == this) {
            counter.FOUND = true;
            return;
        }
        if (this.isNull()) {
            return;
        }
        counter.addCount(this.getTableEntry().countBytes());
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        if (this.isNull()) {
            return 0;
        }
        return this.getTableEntry().writeBytes(stream);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        TableEntry<?, ?> tableEntry = this.createTableEntry(reader);
        this.setTableEntry(tableEntry);
        tableEntry.readBytes(reader);
    }

    public boolean isComplex() {
        return this.getTableEntry() instanceof CompoundEntry;
    }

    public void setTableEntry(TableEntry<?, ?> tableEntry) {
        if (tableEntry == this.mTableEntry) {
            return;
        }
        this.onTableEntryRemoved();
        if (tableEntry == null) {
            return;
        }
        tableEntry.setIndex(0);
        tableEntry.setParent(this);
        this.mTableEntry = tableEntry;
        this.transferSpecReference(tableEntry);
        this.onTableEntryAdded();
    }

    private void transferSpecReference(TableEntry<?, ?> tableEntry) {
        IntegerItem nullSpecReference = this.mNullSpecReference;
        if (nullSpecReference == null) {
            return;
        }
        int ref = nullSpecReference.get();
        this.unlinkNullSpecString();
        Object valueHeader = tableEntry.getHeader();
        if (((ValueHeader)valueHeader).getKey() < 0) {
            ((ValueHeader)valueHeader).setKey(ref);
        }
    }

    private void onTableEntryAdded() {
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            packageBlock.onEntryAdded(this);
        }
    }

    private void onTableEntryRemoved() {
        TableEntry<?, ?> exist = this.mTableEntry;
        if (exist == null) {
            return;
        }
        PackageBlock packageBlock = this.getPackageBlock();
        if (packageBlock != null) {
            packageBlock.removeEntryGroup(this);
        }
        exist.onRemoved();
        exist.setIndex(-1);
        exist.setParent(null);
        this.mTableEntry = null;
    }

    private TableEntry<?, ?> createTableEntry(BlockReader reader) throws IOException {
        int startPosition = reader.getPosition();
        reader.offset(2);
        boolean is_complex = (1 & reader.readShort()) == 1;
        reader.seek(startPosition);
        return this.createTableEntry(is_complex);
    }

    private TableEntry<?, ?> createTableEntry(boolean is_complex) {
        if (is_complex) {
            return new ResTableMapEntry();
        }
        return new ResTableEntry();
    }

    @Override
    public JSONObject toJson() {
        if (this.isNull()) {
            return null;
        }
        return this.getTableEntry().toJson();
    }

    @Override
    public void fromJson(JSONObject json) {
        if (json == null) {
            this.setNull(true);
            return;
        }
        boolean is_complex = json.optBoolean("is_complex", false);
        TableEntry<?, ?> entry = this.createTableEntry(is_complex);
        this.setTableEntry(entry);
        entry.fromJson(json);
    }

    public void merge(Entry entry) {
        if (!this.shouldMerge(entry)) {
            return;
        }
        TableEntry<?, ?> tableEntry = entry.getTableEntry();
        TableEntry<?, ?> existEntry = this.ensureTableEntry(tableEntry instanceof ResTableMapEntry);
        existEntry.merge(tableEntry);
    }

    private boolean shouldMerge(Entry coming) {
        if (coming == null || coming == this || coming.isNull()) {
            return false;
        }
        if (this.isNull()) {
            return true;
        }
        return this.getTableEntry().shouldMerge(coming.getTableEntry());
    }

    public String buildResourceName(int resourceId, char prefix, boolean includeType) {
        if (resourceId == 0) {
            return null;
        }
        Entry entry = this.searchEntry(resourceId);
        return this.buildResourceName(entry, prefix, includeType);
    }

    public String buildResourceName(Entry entry, char prefix, boolean includeType) {
        if (entry == null) {
            return null;
        }
        String pkgName = entry.getPackageName();
        if (this.getResourceId() == entry.getResourceId()) {
            pkgName = null;
        } else if (pkgName != null && pkgName.equals(this.getPackageName())) {
            pkgName = null;
        }
        String type = null;
        if (includeType) {
            type = entry.getTypeName();
        }
        String name = entry.getName();
        return Entry.buildResourceName(prefix, pkgName, type, name);
    }

    public String getResourceName() {
        return Entry.buildResourceName('@', null, this.getTypeName(), this.getName());
    }

    public String getResourceName(char prefix) {
        return this.getResourceName(prefix, false, true);
    }

    public String getResourceName(char prefix, boolean includePackage, boolean includeType) {
        String pkg = includePackage ? this.getPackageName() : null;
        String type = includeType ? this.getTypeName() : null;
        return Entry.buildResourceName(prefix, pkg, type, this.getName());
    }

    public String toString() {
        SpecFlag specFlag;
        StringBuilder builder = new StringBuilder();
        builder.append(HexUtil.toHex8(this.getResourceId()));
        builder.append(' ');
        ResConfig resConfig = this.getResConfig();
        if (resConfig != null) {
            builder.append(resConfig);
            builder.append(' ');
        }
        if ((specFlag = this.getSpecFlag()) != null) {
            builder.append(specFlag);
            builder.append(' ');
        }
        if (this.isNull()) {
            builder.append("NULL ");
        }
        builder.append('@');
        builder.append(this.getTypeName());
        builder.append('/');
        builder.append(this.getName());
        return builder.toString();
    }

    public static String buildResourceName(char prefix, String packageName, String type, String name) {
        if (name == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (prefix != '\u0000') {
            builder.append(prefix);
        }
        if (packageName != null) {
            builder.append(packageName);
            builder.append(':');
        }
        if (type != null) {
            builder.append(type);
            builder.append('/');
        }
        builder.append(name);
        return builder.toString();
    }
}

