/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.array.CompoundItemArray;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.arsc.value.AttributeType;
import com.reandroid.arsc.value.EntryHeaderMap;
import com.reandroid.arsc.value.ResValueMap;
import com.reandroid.arsc.value.TableEntry;
import com.reandroid.arsc.value.ValueHeader;
import com.reandroid.json.JSONObject;

public abstract class CompoundEntry<ITEM extends ResValueMap, ARRAY extends CompoundItemArray<ITEM>>
extends TableEntry<EntryHeaderMap, ARRAY> {
    public static final String NAME_values = "values";

    public CompoundEntry(ARRAY mapArray) {
        super(new EntryHeaderMap(), mapArray);
    }

    public AttributeDataFormat[] getAttributeTypeFormats() {
        ITEM item = this.getByType(AttributeType.FORMATS);
        if (item != null) {
            return ((ResValueMap)item).getAttributeTypeFormats();
        }
        return null;
    }

    public boolean containsType(AttributeType attributeType) {
        return ((CompoundItemArray)this.getValue()).containsType(attributeType);
    }

    public ITEM getByType(AttributeType attributeType) {
        return (ITEM)((CompoundItemArray)this.getValue()).getByType(attributeType);
    }

    @Override
    public void refresh() {
        ((EntryHeaderMap)this.getHeader()).setValuesCount(((CompoundItemArray)this.getValue()).childesCount());
    }

    public ITEM[] listResValueMap() {
        return (ResValueMap[])((CompoundItemArray)this.getValue()).getChildes();
    }

    public int getParentId() {
        return ((EntryHeaderMap)this.getHeader()).getParentId();
    }

    public void setParentId(int parentId) {
        ((EntryHeaderMap)this.getHeader()).setParentId(parentId);
    }

    public int getValuesCount() {
        return ((EntryHeaderMap)this.getHeader()).getValuesCount();
    }

    public void setValuesCount(int valuesCount) {
        ((EntryHeaderMap)this.getHeader()).setValuesCount(valuesCount);
        ((CompoundItemArray)this.getValue()).setChildesCount(valuesCount);
    }

    @Override
    void linkTableStringsInternal(TableStringPool tableStringPool) {
        for (ResValueMap item : this.listResValueMap()) {
            item.linkTableStrings(tableStringPool);
        }
    }

    @Override
    void onHeaderLoaded(ValueHeader valueHeader) {
        ((CompoundItemArray)this.getValue()).setChildesCount(this.getValuesCount());
    }

    @Override
    void onRemoved() {
        ((EntryHeaderMap)this.getHeader()).onRemoved();
        ((CompoundItemArray)this.getValue()).onRemoved();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        ((EntryHeaderMap)this.getHeader()).toJson(jsonObject);
        jsonObject.put(NAME_values, ((CompoundItemArray)this.getValue()).toJson());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        ((EntryHeaderMap)this.getHeader()).fromJson(json);
        ((CompoundItemArray)this.getValue()).fromJson(json.optJSONArray(NAME_values));
        this.refresh();
    }

    @Override
    public String toString() {
        int len;
        StringBuilder builder = new StringBuilder();
        builder.append(this.getHeader());
        ResValueMap[] valueMaps = this.listResValueMap();
        int max = len = valueMaps.length;
        if (max > 4) {
            max = 4;
        }
        for (int i = 0; i < max; ++i) {
            builder.append("\n    ");
            builder.append(valueMaps[i]);
        }
        if (len > 0) {
            if (max != len) {
                builder.append("\n    ...");
            }
            builder.append("\n   ");
        }
        return builder.toString();
    }
}

