/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

public enum AttributeType {
    FORMATS(0x1000000),
    MIN(0x1000001),
    MAX(0x1000002),
    L10N(0x1000003),
    OTHER(0x1000004),
    ZERO(0x1000005),
    ONE(0x1000006),
    TWO(0x1000007),
    FEW(0x1000008),
    MANY(0x1000009);

    private final int id;
    private static final AttributeType[] VALUES;

    private AttributeType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public boolean isPlural() {
        int i = this.id & 0xFFFF;
        return i >= 4 && i <= 9;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.getName();
    }

    public static AttributeType valueOf(int value) {
        for (AttributeType type : VALUES) {
            if (type.getId() != value) continue;
            return type;
        }
        return null;
    }

    public static AttributeType fromName(String name) {
        if (name == null) {
            return null;
        }
        if ("FORMAT".equals(name = name.toUpperCase())) {
            return FORMATS;
        }
        for (AttributeType type : VALUES) {
            if (!name.equals(type.name())) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = AttributeType.values();
    }
}

