/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.value;

import com.reandroid.arsc.value.ValueType;

public enum AttributeDataFormat {
    REFERENCE(1, new ValueType[]{ValueType.REFERENCE, ValueType.ATTRIBUTE, ValueType.DYNAMIC_REFERENCE, ValueType.DYNAMIC_ATTRIBUTE, ValueType.NULL}),
    INTEGER(4, new ValueType[]{ValueType.DEC, ValueType.HEX}),
    BOOL(8, new ValueType[]{ValueType.BOOLEAN}),
    COLOR(16, new ValueType[]{ValueType.COLOR_ARGB8, ValueType.COLOR_RGB8, ValueType.COLOR_RGB4, ValueType.COLOR_ARGB4}),
    FLOAT(32, new ValueType[]{ValueType.FLOAT}),
    DIMENSION(64, new ValueType[]{ValueType.DIMENSION}),
    FRACTION(128, new ValueType[]{ValueType.FRACTION}),
    ANY(65535, (ValueType[])ValueType.values().clone()),
    ENUM(65536, new ValueType[]{ValueType.DEC, ValueType.HEX}),
    FLAG(131072, new ValueType[]{ValueType.HEX, ValueType.DEC}),
    STRING(2, new ValueType[]{ValueType.STRING});

    private final int mask;
    private final ValueType[] valueTypes;
    private static final AttributeDataFormat[] VALUE_TYPES;
    private static final AttributeDataFormat[] BAG_TYPES;

    private AttributeDataFormat(int mask, ValueType[] valueTypes) {
        this.mask = mask;
        this.valueTypes = valueTypes;
    }

    public int getMask() {
        return this.mask;
    }

    public boolean matches(int value) {
        int mask = this.mask;
        return (value & mask) == mask;
    }

    public ValueType[] valueTypes() {
        return this.valueTypes;
    }

    public ValueType[] getValueTypes() {
        return (ValueType[])this.valueTypes.clone();
    }

    public boolean contains(ValueType valueType) {
        ValueType[] valueTypes = this.valueTypes;
        for (int i = 0; i < valueTypes.length; ++i) {
            if (valueType != valueTypes[i]) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name().toLowerCase();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName());
        builder.append('{');
        ValueType[] valueTypes = this.valueTypes;
        for (int i = 0; i < valueTypes.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append((Object)valueTypes[i]);
        }
        builder.append('}');
        return builder.toString();
    }

    public static String toStringValueTypes(int data) {
        return AttributeDataFormat.toString(AttributeDataFormat.decodeValueTypes(data));
    }

    public static String toString(AttributeDataFormat[] typeValues) {
        if (typeValues == null || typeValues.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        int appendedTypes = 0;
        for (AttributeDataFormat typeValue : typeValues) {
            if (typeValue == ENUM || typeValue == FLAG) continue;
            if (typeValue == ANY) {
                return ANY.getName();
            }
            int mask = typeValue.getMask();
            if ((appendedTypes & mask) == mask) continue;
            if (appendOnce) {
                builder.append('|');
            }
            builder.append(typeValue.getName());
            appendOnce = true;
            appendedTypes |= mask;
        }
        return builder.toString();
    }

    public static int sum(AttributeDataFormat[] typeValues) {
        if (typeValues == null) {
            return 0;
        }
        int result = 0;
        for (AttributeDataFormat typeValue : typeValues) {
            if (typeValue == null) continue;
            result |= typeValue.getMask();
        }
        return result;
    }

    public static AttributeDataFormat[] decodeValueTypes(int data) {
        AttributeDataFormat[] tmp = new AttributeDataFormat[VALUE_TYPES.length];
        int length = 0;
        for (AttributeDataFormat typeValue : VALUE_TYPES) {
            int mask = typeValue.getMask();
            if (mask == data) {
                return new AttributeDataFormat[]{typeValue};
            }
            if (typeValue == ANY || (data & mask) != mask) continue;
            tmp[length] = typeValue;
            ++length;
        }
        if (length == 0) {
            return null;
        }
        AttributeDataFormat[] results = new AttributeDataFormat[length];
        System.arraycopy(tmp, 0, results, 0, length);
        return results;
    }

    public static AttributeDataFormat[] parseValueTypes(String valuesTypes) {
        if (valuesTypes == null) {
            return null;
        }
        valuesTypes = valuesTypes.trim();
        String[] valueNames = valuesTypes.split("\\s*\\|\\s*");
        AttributeDataFormat[] tmp = new AttributeDataFormat[VALUE_TYPES.length];
        int length = 0;
        for (String name : valueNames) {
            AttributeDataFormat typeValue = AttributeDataFormat.fromValueTypeName(name);
            if (typeValue == null) continue;
            tmp[length] = typeValue;
            ++length;
        }
        if (length == 0) {
            return null;
        }
        AttributeDataFormat[] results = new AttributeDataFormat[length];
        System.arraycopy(tmp, 0, results, 0, length);
        return results;
    }

    public static AttributeDataFormat valueOf(int mask) {
        for (AttributeDataFormat typeValue : VALUE_TYPES) {
            if (typeValue.getMask() != mask) continue;
            return typeValue;
        }
        return null;
    }

    public static AttributeDataFormat typeOfBag(int data) {
        for (AttributeDataFormat typeValue : BAG_TYPES) {
            if (!typeValue.matches(data)) continue;
            return typeValue;
        }
        return null;
    }

    public static AttributeDataFormat fromValueTypeName(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim().toUpperCase();
        for (AttributeDataFormat typeValue : VALUE_TYPES) {
            if (!name.equals(typeValue.name())) continue;
            return typeValue;
        }
        return null;
    }

    public static AttributeDataFormat fromBagTypeName(String bagTypeName) {
        if (bagTypeName == null) {
            return null;
        }
        bagTypeName = bagTypeName.trim().toUpperCase();
        for (AttributeDataFormat typeValue : BAG_TYPES) {
            if (!bagTypeName.equals(typeValue.name())) continue;
            return typeValue;
        }
        return null;
    }

    public static ValueType[] getExpectedValueTypes(String typeName) {
        AttributeDataFormat dataFormat = AttributeDataFormat.fromValueTypeName(typeName);
        if (dataFormat != null) {
            return dataFormat.valueTypes();
        }
        return null;
    }

    static {
        VALUE_TYPES = new AttributeDataFormat[]{REFERENCE, STRING, INTEGER, BOOL, COLOR, FLOAT, DIMENSION, FRACTION, ANY};
        BAG_TYPES = new AttributeDataFormat[]{ENUM, FLAG};
    }
}

