/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.util;

import java.util.Comparator;
import java.util.List;

public class StringsUtil {
    public static void toStringSort(List<?> itemList) {
        if (itemList == null || itemList.size() < 2) {
            return;
        }
        Comparator<Object> cmp = new Comparator<Object>(){

            @Override
            public int compare(Object obj1, Object obj2) {
                return String.valueOf(obj1).compareTo(String.valueOf(obj2));
            }
        };
        itemList.sort(cmp);
    }

    public static String formatNumber(long number, long maximumValue) {
        int minLength = Long.toString(maximumValue).length();
        return StringsUtil.trailZeros(number, minLength);
    }

    public static String trailZeros(long number, int minLength) {
        boolean negative = false;
        if (number < 0L) {
            negative = true;
            number = -number;
        }
        String text = Long.toString(number);
        int count = minLength - text.length();
        text = StringsUtil.append(text, '0', count, true);
        if (negative) {
            text = "-" + text;
        }
        return text;
    }

    public static String appendPostfix(String text, char ch, int count) {
        return StringsUtil.append(text, ch, count, false);
    }

    public static String append(String text, char ch, int count, boolean prefix) {
        StringBuilder builder = new StringBuilder();
        if (!prefix) {
            builder.append(text);
        }
        for (int i = 0; i < count; ++i) {
            builder.append(ch);
        }
        if (prefix) {
            builder.append(text);
        }
        return builder.toString();
    }
}

