/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.util;

import com.reandroid.arsc.BuildInfo;
import com.reandroid.arsc.array.SpecTypePairArray;
import com.reandroid.arsc.array.TypeBlockArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.PackageBlock;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.TypeBlock;
import com.reandroid.arsc.container.SpecTypePair;
import com.reandroid.arsc.group.EntryGroup;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.TableStringPool;
import com.reandroid.arsc.util.ResNameMap;
import com.reandroid.arsc.value.Entry;
import com.reandroid.arsc.value.ResConfig;
import com.reandroid.common.FileChannelInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FrameworkTable
extends TableBlock {
    private String frameworkName;
    private int versionCode;
    private int mainPackageId;
    private ResNameMap<EntryGroup> mNameGroupMap;
    private boolean mOptimized;
    private boolean mOptimizeChecked;
    private static final String PROP_NAME = "NAME";
    private static final String PROP_VERSION_CODE = "VERSION_CODE";
    private static final String PROP_VERSION_NAME = "VERSION_NAME";
    private static final int PROP_COUNT = 10;

    @Override
    public boolean isAndroid() {
        return "android".equals(this.getFrameworkName()) && this.getMainPackageId() == 1;
    }

    public int getMainPackageId() {
        if (this.mainPackageId != 0) {
            return this.mainPackageId;
        }
        PackageBlock packageBlock = this.pickOne();
        if (packageBlock != null) {
            this.mainPackageId = packageBlock.getId();
        }
        return this.mainPackageId;
    }

    @Override
    public void destroy() {
        this.clearResourceNameMap();
        this.frameworkName = null;
        this.versionCode = 0;
        this.mainPackageId = 0;
        super.destroy();
    }

    public int resolveResourceId(String typeName, String entryName) {
        Entry entry = this.searchEntry(typeName, entryName);
        if (entry != null) {
            return entry.getResourceId();
        }
        return 0;
    }

    public void loadResourceNameMap() {
        ResNameMap<EntryGroup> resNameMap = this.mNameGroupMap;
        if (resNameMap == null) {
            resNameMap = new ResNameMap();
            for (PackageBlock packageBlock : this.listPackages()) {
                for (EntryGroup group : packageBlock.listEntryGroup()) {
                    resNameMap.add(group.getTypeName(), group.getSpecName(), group);
                }
            }
            this.mNameGroupMap = resNameMap;
        }
    }

    public void clearResourceNameMap() {
        if (this.mNameGroupMap != null) {
            this.mNameGroupMap.clear();
            this.mNameGroupMap = null;
        }
    }

    private boolean hasResourceGroupMap() {
        return this.mNameGroupMap != null;
    }

    private Entry searchEntryFromMap(String typeName, String entryName) {
        if (this.mNameGroupMap == null) {
            return null;
        }
        EntryGroup entryGroup = this.mNameGroupMap.get(typeName, entryName);
        if (entryGroup != null) {
            return entryGroup.pickOne();
        }
        return null;
    }

    public Entry searchEntry(String typeName, String entryName) {
        if (this.hasResourceGroupMap()) {
            return this.searchEntryFromMap(typeName, entryName);
        }
        return this.searchEntryFromTable(typeName, entryName);
    }

    public Entry searchEntryFromTable(String typeName, String entryName) {
        for (PackageBlock packageBlock : this.listPackages()) {
            SpecTypePair specTypePair = packageBlock.getSpecTypePair(typeName);
            if (specTypePair == null) continue;
            return specTypePair.getAnyEntry(entryName);
        }
        return null;
    }

    public int getVersionCode() {
        String version;
        if (this.versionCode == 0 && this.isOptimized() && (version = this.loadProperty(PROP_VERSION_CODE)) != null) {
            try {
                this.versionCode = Integer.parseInt(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.versionCode;
    }

    public void setVersionCode(int value) {
        this.versionCode = value;
        if (this.isOptimized()) {
            this.writeVersionCode(value);
        }
    }

    public String getFrameworkName() {
        String name;
        PackageBlock packageBlock;
        if (this.frameworkName == null) {
            this.frameworkName = this.loadProperty(PROP_NAME);
        }
        if (this.frameworkName == null && (packageBlock = this.pickOne()) != null && (name = packageBlock.getName()) != null && !name.trim().isEmpty()) {
            this.frameworkName = name;
        }
        return this.frameworkName;
    }

    public void setFrameworkName(String value) {
        this.frameworkName = value;
        if (this.isOptimized()) {
            this.writeProperty(PROP_NAME, value);
        }
    }

    public void optimize(String name, int version) {
        this.mOptimizeChecked = true;
        this.mOptimized = false;
        this.ensureTypeBlockNonNullEntries();
        this.optimizeEntries();
        this.optimizeTableString();
        this.writeVersionCode(version);
        this.mOptimizeChecked = false;
        this.setFrameworkName(name);
        this.refresh();
    }

    private void ensureTypeBlockNonNullEntries() {
        for (PackageBlock packageBlock : this.listPackages()) {
            this.ensureTypeBlockNonNullEntries(packageBlock);
        }
    }

    private void ensureTypeBlockNonNullEntries(PackageBlock packageBlock) {
        for (SpecTypePair specTypePair : packageBlock.listSpecTypePairs()) {
            this.ensureTypeBlockNonNullEntries(specTypePair);
        }
    }

    private void ensureTypeBlockNonNullEntries(SpecTypePair specTypePair) {
        Map<Integer, EntryGroup> map = specTypePair.createEntryGroups();
        for (EntryGroup entryGroup : map.values()) {
            this.ensureNonNullDefaultEntry(entryGroup);
        }
    }

    private void ensureNonNullDefaultEntry(EntryGroup entryGroup) {
        Entry entry;
        Entry defEntry = entryGroup.getDefault(false);
        if (defEntry == null) {
            entry = entryGroup.pickOne();
            if (entry == null) {
                return;
            }
            SpecTypePair specTypePair = entry.getTypeBlock().getParentSpecTypePair();
            TypeBlock type = specTypePair.getOrCreateTypeBlock(new ResConfig());
            defEntry = type.getOrCreateEntry((short)(entry.getId() & 0xFFFF));
        }
        if (!defEntry.isNull()) {
            return;
        }
        entry = entryGroup.pickOne();
        if (entry.isNull()) {
            return;
        }
        defEntry.merge(entry);
        defEntry.isDefault();
    }

    private void optimizeEntries() {
        Map<Integer, EntryGroup> groupMap = this.scanAllEntryGroups();
        for (EntryGroup group : groupMap.values()) {
            List<Entry> entryList = this.getEntriesToRemove(group);
            this.removeEntries(entryList);
        }
        for (PackageBlock pkg : this.listPackages()) {
            this.removeEmptyBlocks(pkg);
        }
        for (PackageBlock pkg : this.listPackages()) {
            pkg.removeEmpty();
            pkg.refresh();
        }
    }

    private void removeEmptyBlocks(PackageBlock pkg) {
        SpecTypePairArray specTypePairArray = pkg.getSpecTypePairArray();
        specTypePairArray.sort();
        ArrayList specTypePairList = new ArrayList(specTypePairArray.listItems());
        for (SpecTypePair specTypePair : specTypePairList) {
            this.removeEmptyBlocks(specTypePair);
        }
    }

    private void removeEmptyBlocks(SpecTypePair specTypePair) {
        TypeBlockArray typeBlockArray = specTypePair.getTypeBlockArray();
        if (typeBlockArray.childesCount() < 2) {
            return;
        }
        typeBlockArray.removeEmptyBlocks();
    }

    private void optimizeTableString() {
        this.removeUnusedTableString();
        this.shrinkTableString();
        this.getStringPool().getStyleArray().clearChildes();
        this.removeUnusedTableString();
    }

    private void removeUnusedTableString() {
        TableStringPool tableStringPool = this.getStringPool();
        tableStringPool.removeUnusedStrings();
        tableStringPool.refresh();
    }

    private void shrinkTableString() {
        TableStringPool tableStringPool = this.getStringPool();
        tableStringPool.getStringsArray().ensureSize(1);
        TableString title = (TableString)tableStringPool.get(0);
        title.set(BuildInfo.getRepo());
        for (TableString tableString : tableStringPool.getStringsArray().listItems()) {
            if (tableString == title) continue;
            this.shrinkTableString(title, tableString);
        }
        tableStringPool.refresh();
    }

    private void shrinkTableString(TableString zero, TableString tableString) {
        ArrayList<ReferenceItem> allRef = new ArrayList<ReferenceItem>(tableString.getReferencedList());
        tableString.removeAllReference();
        for (ReferenceItem item : allRef) {
            item.set(zero.getIndex());
        }
        zero.addReference(allRef);
    }

    private void removeEntries(List<Entry> removeList) {
        for (Entry entry : removeList) {
            this.removeEntry(entry);
        }
    }

    private void removeEntry(Entry entry) {
        TypeBlock typeBlock = entry.getTypeBlock();
        if (typeBlock == null) {
            return;
        }
        typeBlock.removeEntry(entry);
    }

    private List<Entry> getEntriesToRemove(EntryGroup group) {
        ArrayList<Entry> results = new ArrayList<Entry>();
        Entry mainEntry = group.pickOne();
        if (mainEntry == null) {
            return results;
        }
        Iterator itr = group.iterator(true);
        while (itr.hasNext()) {
            Entry entry = (Entry)itr.next();
            if (entry == mainEntry) continue;
            results.add(entry);
        }
        return results;
    }

    private Map<Integer, EntryGroup> scanAllEntryGroups() {
        HashMap<Integer, EntryGroup> results = new HashMap<Integer, EntryGroup>();
        for (PackageBlock packageBlock : this.listPackages()) {
            Map<Integer, EntryGroup> map = packageBlock.getEntriesGroupMap();
            for (Map.Entry<Integer, EntryGroup> entry : map.entrySet()) {
                int id = entry.getKey();
                EntryGroup group = entry.getValue();
                EntryGroup exist = (EntryGroup)results.get(id);
                if (exist != null && exist.getDefault() != null) {
                    if (exist.getDefault() != null) continue;
                    results.remove(id);
                }
                results.put(id, group);
            }
        }
        return results;
    }

    private TableString writeProperty(String name, String value) {
        TableString tableString;
        if (!name.endsWith(":")) {
            name = name + ":";
        }
        if (value == null) {
            value = "";
        }
        if (!value.startsWith(name)) {
            value = name + value;
        }
        if ((tableString = this.loadPropertyString(name)) != null) {
            tableString.set(value);
        } else {
            TableStringPool tableStringPool = this.getStringPool();
            tableString = (TableString)tableStringPool.getOrCreate(value);
        }
        return tableString;
    }

    private String loadProperty(String name) {
        TableString tableString;
        if (name == null) {
            return null;
        }
        if (!name.endsWith(":")) {
            name = name + ":";
        }
        if ((tableString = this.loadPropertyString(name)) == null) {
            return null;
        }
        String str = tableString.get().trim();
        return str.substring(name.length()).trim();
    }

    private TableString loadPropertyString(String name) {
        TableString tableString;
        if (name == null) {
            return null;
        }
        if (!name.endsWith(":")) {
            name = name + ":";
        }
        TableStringPool tableStringPool = this.getStringPool();
        int max = 10;
        for (int i = 0; i < max && (tableString = (TableString)tableStringPool.get(i)) != null; ++i) {
            String str = tableString.get();
            if (str == null || !(str = str.trim()).startsWith(name)) continue;
            return tableString;
        }
        return null;
    }

    public boolean isOptimized() {
        if (!this.mOptimizeChecked) {
            this.mOptimizeChecked = true;
            String version = this.loadProperty(PROP_VERSION_CODE);
            if (version != null) {
                try {
                    int v = Integer.parseInt(version);
                    this.mOptimized = v != 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return this.mOptimized;
    }

    private void writeVersionCode(int value) {
        this.writeProperty(PROP_VERSION_CODE, String.valueOf(value));
    }

    @Override
    public String toString() {
        Object headerBlock = this.getHeaderBlock();
        if (((HeaderBlock)headerBlock).getChunkType() != ChunkType.TABLE) {
            return super.toString();
        }
        if (!this.mOptimized) {
            return "Unoptimized: " + super.toString();
        }
        return this.getFrameworkName() + '-' + this.getVersionCode();
    }

    public static FrameworkTable load(File file) throws IOException {
        return FrameworkTable.load(new FileChannelInputStream(file));
    }

    public static FrameworkTable load(InputStream inputStream) throws IOException {
        FrameworkTable frameworkTable = new FrameworkTable();
        frameworkTable.readBytes(inputStream);
        return frameworkTable;
    }
}

