/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool.builder;

import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.model.StyleSpanInfo;
import com.reandroid.arsc.pool.TableStringPool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringPoolMerger
implements Comparator<String> {
    private final Set<TableStringPool> mPools = new HashSet<TableStringPool>();
    private int mMergedPools;
    private int mMergedStrings;
    private int mMergedStyleStrings;

    public void mergeTo(TableStringPool destination) {
        this.mMergedPools = 0;
        this.mMergedStrings = 0;
        this.mMergedStyleStrings = 0;
        if (destination.countStrings() > 0 || destination.countStyles() > 0) {
            throw new IllegalArgumentException("Destination string pool is not empty");
        }
        this.mergeStyledStrings(destination);
        this.mergeNonStyledStrings(destination);
        this.mMergedPools = this.mPools.size();
        this.mPools.clear();
        destination.refresh();
    }

    public void add(TableStringPool stringPool) {
        this.mPools.add(stringPool);
    }

    public int getMergedPools() {
        return this.mMergedPools;
    }

    public int getMergedStyleStrings() {
        return this.mMergedStyleStrings;
    }

    public int getMergedStrings() {
        return this.mMergedStrings;
    }

    private void mergeStyledStrings(TableStringPool destination) {
        List<TableString> styledStrings = this.getStyledStrings();
        Map mapTableStrings = destination.insertStrings(this.toStringList(styledStrings));
        Map mapTags = destination.insertStrings(this.listStyleTags(styledStrings));
        StyleArray styleArray = destination.getStyleArray();
        styleArray.setChildesCount(styledStrings.size());
        for (TableString tableString : styledStrings) {
            TableString createdString = (TableString)mapTableStrings.get(tableString.get());
            StyleItem createdStyle = (StyleItem)styleArray.get(createdString.getIndex());
            StyleItem styleItem = tableString.getStyle();
            for (StyleSpanInfo spanInfo : styleItem.getSpanInfoList()) {
                if (spanInfo == null || createdStyle == null) continue;
                int tagReference = ((TableString)mapTags.get(spanInfo.getTag())).getIndex();
                createdStyle.addStylePiece(tagReference, spanInfo.getFirst(), spanInfo.getLast());
            }
        }
        this.mMergedStyleStrings = styledStrings.size();
    }

    private void mergeNonStyledStrings(TableStringPool destination) {
        List<String> nonStyledStrings = this.getNonStyledStrings();
        destination.insertStrings(nonStyledStrings);
        this.mMergedStrings = nonStyledStrings.size();
    }

    private List<TableString> getStyledStrings() {
        HashMap<String, TableString> mapUniqueHtml = new HashMap<String, TableString>();
        for (TableStringPool pool : this.mPools) {
            int styleCount = pool.countStyles();
            StringArray stringArray = pool.getStringsArray();
            for (int i = 0; i < styleCount; ++i) {
                TableString tableString = (TableString)stringArray.get(i);
                if (tableString == null || !tableString.hasStyle()) continue;
                mapUniqueHtml.put(tableString.getHtml(), tableString);
            }
        }
        return new ArrayList<TableString>(mapUniqueHtml.values());
    }

    private List<String> getNonStyledStrings() {
        HashSet<String> uniqueSet = new HashSet<String>();
        for (TableStringPool pool : this.mPools) {
            TableString[] tableStrings = (TableString[])pool.getStrings();
            if (tableStrings == null) continue;
            for (int i = 0; i < tableStrings.length; ++i) {
                TableString tableString = tableStrings[i];
                if (tableString == null || tableString.hasStyle()) continue;
                uniqueSet.add(tableString.get());
            }
        }
        ArrayList<String> results = new ArrayList<String>(uniqueSet);
        results.sort(this);
        return results;
    }

    private List<String> toStringList(Collection<TableString> tableStringList) {
        ArrayList<String> results = new ArrayList<String>(tableStringList.size());
        for (TableString tableString : tableStringList) {
            String str = tableString.get();
            if (str == null) continue;
            results.add(str);
        }
        results.sort(this);
        return results;
    }

    private List<String> listStyleTags(List<TableString> styledStrings) {
        HashSet<String> resultSet = new HashSet<String>();
        for (TableString tableString : styledStrings) {
            StyleItem style = tableString.getStyle();
            if (style == null) continue;
            for (StyleSpanInfo spanInfo : style.getSpanInfoList()) {
                if (spanInfo == null) continue;
                resultSet.add(spanInfo.getTag());
            }
        }
        ArrayList<String> results = new ArrayList<String>(resultSet);
        results.sort(this);
        return results;
    }

    @Override
    public int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }
}

