/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.TypeStringArray;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.TypeString;
import com.reandroid.arsc.pool.StringPool;

public class TypeStringPool
extends StringPool<TypeString> {
    private final IntegerItem mTypeIdOffset;

    public TypeStringPool(boolean is_utf8, IntegerItem typeIdOffset) {
        super(is_utf8, false);
        this.mTypeIdOffset = typeIdOffset;
    }

    public int getLastId() {
        int count = this.countStrings();
        return this.toTypeId(count - 1);
    }

    public int idOf(String typeName) {
        return this.idOf(this.getByName(typeName));
    }

    public int idOf(TypeString typeString) {
        if (typeString == null) {
            return this.toTypeId(0);
        }
        return this.toTypeId(typeString.getIndex());
    }

    public TypeString getByName(String name) {
        for (TypeString typeString : this.listStrings()) {
            if (!name.equals(typeString.get())) continue;
            return typeString;
        }
        return null;
    }

    public TypeString getById(int id) {
        return (TypeString)super.get(this.toIndex(id));
    }

    public TypeString getOrCreate(int typeId, String typeName) {
        StringArray stringsArray = this.getStringsArray();
        int old = stringsArray.childesCount();
        int size = this.toIndex(typeId) + 1;
        stringsArray.ensureSize(size);
        TypeString typeString = this.getById(typeId);
        typeString.set(typeName);
        if (old != stringsArray.childesCount()) {
            this.updateUniqueIdMap(typeString);
        }
        return typeString;
    }

    private int toIndex(int typeId) {
        return typeId - 1 - this.mTypeIdOffset.get();
    }

    private int toTypeId(int index) {
        return index + 1 + this.mTypeIdOffset.get();
    }

    @Override
    @Deprecated
    public final TypeString getOrCreate(String str) {
        StringGroup group = this.get(str);
        if (group == null || group.size() == 0) {
            throw new IllegalArgumentException("Can not create TypeString (" + str + ") without type id. use getOrCreate(typeId, typeName)");
        }
        return (TypeString)group.get(0);
    }

    @Override
    StringArray<TypeString> newInstance(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        return new TypeStringArray(offsets, itemCount, itemStart, is_utf8);
    }
}

