/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.TableStringArray;
import com.reandroid.arsc.chunk.ChunkType;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.arsc.chunk.UnknownChunk;
import com.reandroid.arsc.header.HeaderBlock;
import com.reandroid.arsc.header.TableHeader;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.TableString;
import com.reandroid.arsc.pool.StringPool;
import java.io.IOException;
import java.io.InputStream;

public class TableStringPool
extends StringPool<TableString> {
    public TableStringPool(boolean is_utf8) {
        super(is_utf8);
    }

    @Override
    void linkStrings() {
        TableBlock tableBlock = this.getParentInstance(TableBlock.class);
        if (tableBlock != null) {
            tableBlock.linkTableStringsInternal(this);
        }
    }

    @Override
    StringArray<TableString> newInstance(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        return new TableStringArray(offsets, itemCount, itemStart, is_utf8);
    }

    public void merge(TableStringPool stringPool) {
        if (stringPool == null || stringPool == this) {
            return;
        }
        StringArray existArray = this.getStringsArray();
        if (existArray.childesCount() != 0) {
            return;
        }
        StringArray comingArray = stringPool.getStringsArray();
        int count = comingArray.childesCount();
        existArray.ensureSize(count);
        for (int i = 0; i < count; ++i) {
            TableString exist = (TableString)existArray.get(i);
            TableString coming = (TableString)comingArray.get(i);
            exist.set(coming.get());
        }
        this.getStyleArray().merge(stringPool.getStyleArray());
        this.refreshUniqueIdMap();
    }

    public static TableStringPool readFromTable(InputStream inputStream) throws IOException {
        TableHeader tableHeader = new TableHeader();
        tableHeader.readBytes(inputStream);
        if (tableHeader.getChunkType() != ChunkType.TABLE) {
            throw new IOException("Not TableBlock: " + tableHeader);
        }
        UnknownChunk poolChunk = new UnknownChunk();
        poolChunk.readBytes(inputStream);
        Object poolHeader = poolChunk.getHeaderBlock();
        if (((HeaderBlock)poolHeader).getChunkType() != ChunkType.STRING) {
            throw new IOException("Not StringPool chunk: " + poolChunk);
        }
        BlockReader blockReader = new BlockReader(poolChunk.getBytes());
        TableStringPool stringPool = new TableStringPool(true);
        stringPool.readBytes(blockReader);
        blockReader.close();
        return stringPool;
    }
}

