/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.chunk.Chunk;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.header.StringPoolHeader;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.StringItem;
import com.reandroid.arsc.item.StyleItem;
import com.reandroid.arsc.pool.JsonStringPoolHelper;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class StringPool<T extends StringItem>
extends Chunk<StringPoolHeader>
implements BlockLoad,
JSONConvert<JSONArray>,
Comparator<String> {
    private final Object mLock = new Object();
    private final StringArray<T> mArrayStrings;
    private final StyleArray mArrayStyles;
    private final Map<String, StringGroup<T>> mUniqueMap;
    private boolean stringLinkLocked;

    StringPool(boolean is_utf8, boolean stringLinkLocked) {
        super(new StringPoolHeader(), 4);
        OffsetArray offsetStrings = new OffsetArray();
        OffsetArray offsetStyles = new OffsetArray();
        StringPoolHeader header = (StringPoolHeader)this.getHeaderBlock();
        this.mArrayStrings = this.newInstance(offsetStrings, header.getCountStrings(), header.getStartStrings(), is_utf8);
        this.mArrayStyles = new StyleArray(offsetStyles, header.getCountStyles(), header.getStartStyles());
        this.addChild(offsetStrings);
        this.addChild(offsetStyles);
        this.addChild(this.mArrayStrings);
        this.addChild(this.mArrayStyles);
        this.setUtf8(is_utf8, false);
        header.getFlagUtf8().setBlockLoad(this);
        this.mUniqueMap = new HashMap<String, StringGroup<T>>();
        this.stringLinkLocked = stringLinkLocked;
    }

    StringPool(boolean is_utf8) {
        this(is_utf8, true);
    }

    public boolean isStringLinkLocked() {
        return this.stringLinkLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureStringLinkUnlockedInternal() {
        if (!this.stringLinkLocked) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.stringLinkLocked) {
                return;
            }
            this.stringLinkLocked = false;
            this.linkStrings();
        }
    }

    void linkStrings() {
    }

    public void removeString(T item) {
        this.getStringsArray().remove(item);
    }

    public void destroy() {
        this.getStyleArray().clearChildes();
        this.getStringsArray().clearChildes();
    }

    public List<String> toStringList() {
        return this.getStringsArray().toStringList();
    }

    public void addStrings(Collection<String> stringList) {
        if (stringList == null || stringList.size() == 0) {
            return;
        }
        HashSet<String> uniqueSet = stringList instanceof HashSet ? (HashSet<String>)stringList : new HashSet<String>(stringList);
        this.refreshUniqueIdMap();
        Set<String> keySet = this.mUniqueMap.keySet();
        for (String key : keySet) {
            uniqueSet.remove(key);
        }
        ArrayList<String> sortedList = new ArrayList<String>(uniqueSet);
        sortedList.sort(this);
        this.insertStringList(sortedList);
    }

    private void insertStringList(List<String> stringList) {
        StringArray<T> stringsArray = this.getStringsArray();
        int initialSize = stringsArray.childesCount();
        stringsArray.ensureSize(initialSize + stringList.size());
        int size = stringsArray.childesCount();
        int j = 0;
        for (int i = initialSize; i < size; ++i) {
            StringItem item = (StringItem)stringsArray.get(i);
            item.set(stringList.get(j));
            ++j;
        }
        this.refreshUniqueIdMap();
    }

    public Map<String, T> insertStrings(List<String> stringList) {
        HashMap<String, StringItem> results = new HashMap<String, StringItem>();
        StringArray<T> stringsArray = this.getStringsArray();
        int initialSize = stringsArray.childesCount();
        stringsArray.ensureSize(initialSize + stringList.size());
        int size = stringsArray.childesCount();
        int j = 0;
        for (int i = initialSize; i < size; ++i) {
            StringItem item = (StringItem)stringsArray.get(i);
            String str = stringList.get(j);
            item.set(str);
            results.put(str, item);
            ++j;
        }
        this.refreshUniqueIdMap();
        return results;
    }

    public void refreshUniqueIdMap() {
        this.mUniqueMap.clear();
        StringItem[] stringsArray = this.getStrings();
        if (stringsArray == null) {
            return;
        }
        for (int i = 0; i < stringsArray.length; ++i) {
            String str;
            StringItem item = stringsArray[i];
            if (item == null || (str = item.getHtml()) == null) continue;
            StringGroup<StringItem> group = this.getOrCreateGroup(str);
            group.add(item);
        }
    }

    void updateUniqueIdMap(T item) {
        if (item == null) {
            return;
        }
        StringGroup<T> group = this.getOrCreateGroup(((StringItem)item).getHtml());
        group.add(item);
    }

    public List<T> removeUnusedStrings() {
        return this.getStringsArray().removeUnusedStrings();
    }

    public List<T> listUnusedStrings() {
        return this.getStringsArray().listUnusedStrings();
    }

    public Collection<T> listStrings() {
        return this.getStringsArray().listItems();
    }

    public StyleArray getStyleArray() {
        return this.mArrayStyles;
    }

    public StringArray<T> getStringsArray() {
        return this.mArrayStrings;
    }

    public void removeReferences(Collection<ReferenceItem> referenceList) {
        if (referenceList == null) {
            return;
        }
        for (ReferenceItem ref : referenceList) {
            this.removeReference(ref);
        }
    }

    public T removeReference(ReferenceItem ref) {
        if (ref == null) {
            return null;
        }
        T item = this.get(ref.get());
        if (item != null) {
            ((StringItem)item).removeReference(ref);
            return item;
        }
        return null;
    }

    public void addReference(ReferenceItem ref) {
        if (ref == null) {
            return;
        }
        T item = this.get(ref.get());
        if (item != null) {
            ((StringItem)item).addReference(ref);
        }
    }

    public void addReferences(Collection<ReferenceItem> referenceList) {
        if (referenceList == null) {
            return;
        }
        for (ReferenceItem ref : referenceList) {
            this.addReference(ref);
        }
    }

    public boolean contains(String str) {
        return this.mUniqueMap.containsKey(str);
    }

    public final T get(int index) {
        return (T)((StringItem)this.mArrayStrings.get(index));
    }

    public final StringGroup<T> get(String str) {
        return this.mUniqueMap.get(str);
    }

    public T getOrCreate(String str) {
        StringGroup<T> group = this.getOrCreateGroup(str);
        StringItem[] items = (StringItem[])group.getItems();
        if (items.length == 0) {
            T t = this.createNewString(str);
            group.add(t);
            items = (StringItem[])group.getItems();
        }
        return (T)items[0];
    }

    private StringGroup<T> getOrCreateGroup(String str) {
        StringGroup<T> group = this.get(str);
        if (group != null) {
            return group;
        }
        group = new StringGroup<T>(this.mArrayStrings, str);
        this.mUniqueMap.put(str, group);
        return group;
    }

    private T createNewString(String str) {
        StringItem item = (StringItem)this.mArrayStrings.createNext();
        item.set(str);
        ((StringPoolHeader)this.getHeaderBlock()).getCountStrings().set(this.mArrayStrings.childesCount());
        return (T)item;
    }

    public final StyleItem getStyle(int index) {
        return (StyleItem)this.mArrayStyles.get(index);
    }

    public final int countStrings() {
        return this.mArrayStrings.childesCount();
    }

    public final int countStyles() {
        return this.mArrayStyles.childesCount();
    }

    public final T[] getStrings() {
        return (StringItem[])this.mArrayStrings.getChildes();
    }

    public final StyleItem[] getStyles() {
        return (StyleItem[])this.mArrayStyles.getChildes();
    }

    public void setUtf8(boolean is_utf8) {
        this.setUtf8(is_utf8, true);
    }

    private void setUtf8(boolean is_utf8, boolean updateAll) {
        StringPoolHeader header = (StringPoolHeader)this.getHeaderBlock();
        if (is_utf8 == header.isUtf8()) {
            return;
        }
        ByteItem flagUtf8 = header.getFlagUtf8();
        if (is_utf8) {
            flagUtf8.set((byte)1);
        } else {
            flagUtf8.set((byte)0);
        }
        if (!updateAll) {
            return;
        }
        this.mArrayStrings.setUtf8(is_utf8);
    }

    public void setFlagSorted(boolean sorted) {
        ((StringPoolHeader)this.getHeaderBlock()).setSorted(sorted);
    }

    abstract StringArray<T> newInstance(OffsetArray var1, IntegerItem var2, IntegerItem var3, boolean var4);

    @Override
    protected void onChunkRefreshed() {
        this.mArrayStrings.refreshCountAndStart();
        this.mArrayStyles.refreshCountAndStart();
    }

    @Override
    public void onChunkLoaded() {
        this.refreshUniqueIdMap();
        StyleItem[] styles = this.getStyles();
        if (styles != null) {
            for (StyleItem styleItem : styles) {
                styleItem.onDataLoaded();
            }
        }
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        StringPoolHeader header = (StringPoolHeader)this.getHeaderBlock();
        if (sender == header.getFlagUtf8()) {
            this.mArrayStrings.setUtf8(header.isUtf8());
        }
    }

    @Override
    public JSONArray toJson() {
        return this.getStringsArray().toJson();
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null) {
            return;
        }
        JsonStringPoolHelper helper = new JsonStringPoolHelper(this);
        helper.loadStyledStrings(json);
        this.refresh();
    }

    @Override
    public int compare(String s1, String s2) {
        return s1.compareTo(s2);
    }
}

