/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.pool;

import com.reandroid.arsc.array.OffsetArray;
import com.reandroid.arsc.array.ResXmlIDArray;
import com.reandroid.arsc.array.ResXmlStringArray;
import com.reandroid.arsc.array.StringArray;
import com.reandroid.arsc.array.StyleArray;
import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.chunk.xml.ResXmlIDMap;
import com.reandroid.arsc.group.StringGroup;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ResXmlID;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.StringPool;
import java.util.Objects;

public class ResXmlStringPool
extends StringPool<ResXmlString> {
    private static boolean HAS_STYLE_NOTIFIED;

    public ResXmlStringPool(boolean is_utf8) {
        super(is_utf8, false);
    }

    @Override
    public ResXmlString removeReference(ReferenceItem referenceItem) {
        if (referenceItem == null) {
            return null;
        }
        ResXmlString stringItem = (ResXmlString)super.removeReference(referenceItem);
        this.removeNotUsedItem(stringItem);
        return stringItem;
    }

    private void removeNotUsedItem(ResXmlString xmlString) {
        if (xmlString == null || xmlString.hasReference()) {
            return;
        }
        ResXmlIDMap idMap = this.getResXmlIDMap();
        int lastIdIndex = -1;
        if (idMap != null) {
            lastIdIndex = idMap.countId() - 1;
        }
        if (idMap != null && xmlString.getIndex() > lastIdIndex) {
            this.removeString(xmlString);
        } else {
            xmlString.set("");
        }
    }

    @Override
    StringArray<ResXmlString> newInstance(OffsetArray offsets, IntegerItem itemCount, IntegerItem itemStart, boolean is_utf8) {
        return new ResXmlStringArray(offsets, itemCount, itemStart, is_utf8);
    }

    @Override
    public ResXmlString getOrCreate(String str) {
        return this.getOrCreateAttribute(0, str);
    }

    public ResXmlString createNew(String str) {
        StringArray stringsArray = this.getStringsArray();
        ResXmlString xmlString = (ResXmlString)stringsArray.createNext();
        xmlString.set(str);
        return xmlString;
    }

    public ResXmlString getOrCreateAttribute(int resourceId, String str) {
        ResXmlString xmlString;
        ResXmlIDMap resXmlIDMap = this.getResXmlIDMap();
        if (resXmlIDMap == null) {
            return (ResXmlString)super.getOrCreate(str);
        }
        ResXmlIDArray idArray = resXmlIDMap.getResXmlIDArray();
        int count = idArray.childesCount();
        if (resourceId == 0) {
            return this.getOrCreateAfter(count, str);
        }
        StringArray<ResXmlString> stringsArray = this.getStringsArray();
        ResXmlID xmlID = idArray.getByResId(resourceId);
        if (xmlID != null && (xmlString = (ResXmlString)stringsArray.get(xmlID.getIndex())) != null && Objects.equals(str, xmlString.get())) {
            return xmlString;
        }
        count = idArray.childesCount() + 1;
        stringsArray.ensureSize(count);
        idArray.setChildesCount(count);
        int index = count - 1;
        xmlID = (ResXmlID)idArray.get(index);
        xmlID.set(resourceId);
        idArray.refreshIdMap();
        ResXmlString xmlString2 = (ResXmlString)stringsArray.newInstance();
        xmlString2.set(str);
        stringsArray.insertItem(index, xmlString2);
        this.updateUniqueIdMap(xmlString2);
        return xmlString2;
    }

    private ResXmlString getOrCreateAfter(int position, String str) {
        StringArray stringsArray;
        int count;
        StringGroup group;
        if (position < 0) {
            position = 0;
        }
        if ((group = this.get(str)) != null) {
            for (ResXmlString xmlString : group.listItems()) {
                int index = xmlString.getIndex();
                if (index <= position && (position != 0 || position != index)) continue;
                return xmlString;
            }
        }
        if ((count = (stringsArray = this.getStringsArray()).childesCount()) < position) {
            count = position;
        }
        stringsArray.ensureSize(count + 1);
        ResXmlString xmlString = (ResXmlString)stringsArray.get(count);
        xmlString.set(str);
        super.updateUniqueIdMap(xmlString);
        return xmlString;
    }

    private ResXmlIDMap getResXmlIDMap() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getResXmlIDMap();
        }
        return null;
    }

    public ResXmlString getOrCreateAttributeName(int idMapCount, String str) {
        StringGroup group = this.get(str);
        if (group != null) {
            for (ResXmlString xmlString : group.listItems()) {
                if (xmlString.getIndex() <= idMapCount) continue;
                return xmlString;
            }
        }
        StringArray stringsArray = this.getStringsArray();
        stringsArray.ensureSize(idMapCount);
        int i = stringsArray.childesCount();
        stringsArray.ensureSize(i + 1);
        ResXmlString xmlString = (ResXmlString)stringsArray.get(i);
        xmlString.set(str);
        this.refreshUniqueIdMap();
        return xmlString;
    }

    @Override
    public void onChunkLoaded() {
        super.onChunkLoaded();
        StyleArray styleArray = this.getStyleArray();
        if (styleArray.childesCount() > 0) {
            ResXmlStringPool.notifyResXmlStringPoolHasStyles(styleArray.childesCount());
        }
    }

    private static void notifyResXmlStringPoolHasStyles(int styleArrayCount) {
        if (HAS_STYLE_NOTIFIED) {
            return;
        }
        String msg = "Not expecting ResXmlStringPool to have styles count=" + styleArrayCount + ",\n please create issue along with this apk/file on https://github.com/REAndroid/ARSCLib";
        System.err.println(msg);
        HAS_STYLE_NOTIFIED = true;
    }
}

