/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.arsc.model.StyleSpanInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StyledStringBuilder {
    public static String build(String text, Collection<StyleSpanInfo> spanInfoList, boolean xml) {
        if (StyledStringBuilder.isEmpty(spanInfoList)) {
            return text;
        }
        CharPiece[] charPieceArray = StyledStringBuilder.toCharPieceArray(text);
        boolean spansOk = StyledStringBuilder.initializeTags(charPieceArray, spanInfoList, xml);
        if (!spansOk) {
            return text;
        }
        if (xml) {
            StyledStringBuilder.escapeXmlChars(charPieceArray);
        }
        StringBuilder builder = new StringBuilder();
        for (CharPiece charPiece : charPieceArray) {
            charPiece.append(builder);
        }
        return builder.toString();
    }

    private static boolean isEmpty(Collection<StyleSpanInfo> spanInfoList) {
        if (spanInfoList == null || spanInfoList.size() == 0) {
            return true;
        }
        for (StyleSpanInfo spanInfo : spanInfoList) {
            if (spanInfo == null) continue;
            return false;
        }
        return true;
    }

    private static boolean initializeTags(CharPiece[] charPieceArray, Collection<StyleSpanInfo> spanInfoList, boolean xml) {
        for (StyleSpanInfo spanInfo : spanInfoList) {
            boolean spanOk;
            if (spanInfo == null || (spanOk = StyledStringBuilder.initializeTag(charPieceArray, spanInfo, xml))) continue;
            return false;
        }
        return true;
    }

    private static boolean initializeTag(CharPiece[] charPieceArray, StyleSpanInfo spanInfo, boolean xml) {
        int length = charPieceArray.length;
        int pos = spanInfo.getFirst();
        if (pos < 0 || pos >= length) {
            return false;
        }
        CharPiece charPiece = charPieceArray[pos];
        charPiece.addFirstTag(spanInfo.getStartTag(xml));
        pos = spanInfo.getLast();
        if (pos < 0 || pos >= length) {
            return false;
        }
        charPiece = charPieceArray[pos];
        charPiece.addLastTag(spanInfo.getEndTag());
        return true;
    }

    private static void escapeXmlChars(CharPiece[] charPieceArray) {
        int length = charPieceArray.length;
        for (int i = 0; i < length; ++i) {
            CharPiece charPiece = charPieceArray[i];
            if (!StyledStringBuilder.isSpecialXmlChar(charPiece.mChar) || StyledStringBuilder.isAlreadyEscaped(charPieceArray, i)) continue;
            charPiece.escapedXml = StyledStringBuilder.escapeXmlChar(charPiece.mChar);
        }
    }

    private static boolean isAlreadyEscaped(CharPiece[] charPieceArray, int position) {
        if (charPieceArray[position].mChar != '&') {
            return false;
        }
        if (position + 3 >= charPieceArray.length) {
            return false;
        }
        if (charPieceArray[position + 3].mChar == ';') {
            char ch = charPieceArray[position + 1].mChar;
            return charPieceArray[position + 2].mChar == 't' && (ch == 'l' || ch == 'g');
        }
        if (position + 4 >= charPieceArray.length) {
            return false;
        }
        if (charPieceArray[position + 4].mChar == ';') {
            return charPieceArray[position + 1].mChar == 'a' && charPieceArray[position + 2].mChar == 'm' && charPieceArray[position + 3].mChar == 'p';
        }
        return false;
    }

    private static String escapeXmlChar(char ch) {
        switch (ch) {
            case '&': {
                return "&amp;";
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
        }
        throw new IllegalArgumentException("Not special xml char: '" + ch + "'");
    }

    private static boolean isSpecialXmlChar(char ch) {
        switch (ch) {
            case '&': 
            case '<': 
            case '>': {
                return true;
            }
        }
        return false;
    }

    private static CharPiece[] toCharPieceArray(String text) {
        char[] chars = text.toCharArray();
        int length = chars.length;
        CharPiece[] results = new CharPiece[length];
        for (int i = 0; i < length; ++i) {
            results[i] = new CharPiece(i, chars[i]);
        }
        return results;
    }

    static class CharPiece {
        final int position;
        private List<String> firstTagList;
        final char mChar;
        private List<String> lastTagList;
        String escapedXml;

        CharPiece(int position, char ch) {
            this.position = position;
            this.mChar = ch;
        }

        void append(StringBuilder builder) {
            if (this.firstTagList != null) {
                for (String tag : this.firstTagList) {
                    builder.append(tag);
                }
            }
            if (this.escapedXml != null) {
                builder.append(this.escapedXml);
            } else {
                builder.append(this.mChar);
            }
            if (this.lastTagList != null) {
                for (String tag : this.lastTagList) {
                    builder.append(tag);
                }
            }
        }

        void addFirstTag(String tag) {
            if (tag == null) {
                return;
            }
            if (this.firstTagList == null) {
                this.firstTagList = new ArrayList<String>(2);
            }
            this.firstTagList.add(tag);
        }

        void addLastTag(String tag) {
            if (tag == null) {
                return;
            }
            if (this.lastTagList == null) {
                this.lastTagList = new ArrayList<String>(2);
            }
            this.lastTagList.add(0, tag);
        }
    }
}

