/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.model;

import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;

public class StyleSpanInfo
implements JSONConvert<JSONObject> {
    private String mTag;
    private int mFirst;
    private int mLast;
    public static final String NAME_tag = "tag";
    public static final String NAME_first = "first";
    public static final String NAME_last = "last";

    public StyleSpanInfo(String tag, int first, int last) {
        this.mTag = tag;
        this.mFirst = first;
        this.mLast = last;
    }

    public boolean isValid() {
        return this.mFirst < this.mLast && this.mTag != null;
    }

    public int getFirst() {
        return this.mFirst;
    }

    public void setFirst(int first) {
        this.mFirst = first;
    }

    public int getLast() {
        return this.mLast;
    }

    public void setLast(int last) {
        this.mLast = last;
    }

    public String getTag() {
        return this.mTag;
    }

    public void setTag(String tag) {
        this.mTag = tag;
    }

    public String getStartTag(boolean xml) {
        if (this.mTag == null) {
            return null;
        }
        int i = this.mTag.indexOf(59);
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        if (i < 0) {
            builder.append(this.mTag);
        } else {
            builder.append(this.mTag, 0, i);
            builder.append(' ');
            String attrs = this.mTag.substring(i + 1);
            if (xml) {
                this.appendXmlAttrs(builder, attrs);
            } else {
                builder.append(attrs);
            }
        }
        builder.append('>');
        return builder.toString();
    }

    private void appendXmlAttrs(StringBuilder builder, String rawAttr) {
        String[] split = rawAttr.split("(\\s*;\\s*)");
        for (int i = 0; i < split.length; ++i) {
            String attr = split[i];
            if (i != 0) {
                builder.append(' ');
            }
            int index = attr.indexOf(61) + 1;
            builder.append(attr, 0, index);
            builder.append('\"');
            builder.append(attr.substring(index));
            builder.append('\"');
        }
    }

    public String getEndTag() {
        if (this.mTag == null) {
            return null;
        }
        int i = this.mTag.indexOf(59);
        if (i < 0) {
            i = this.mTag.indexOf(32);
        }
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        builder.append('/');
        if (i < 0) {
            builder.append(this.mTag);
        } else {
            builder.append(this.mTag, 0, i);
        }
        builder.append('>');
        return builder.toString();
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NAME_tag, this.mTag);
        jsonObject.put(NAME_first, this.mFirst);
        jsonObject.put(NAME_last, this.mLast);
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setTag(json.getString(NAME_tag));
        this.setFirst(json.getInt(NAME_first));
        this.setLast(json.getInt(NAME_last));
    }

    public String toString() {
        return this.mTag + " (" + this.mFirst + ", " + this.mLast + ")";
    }
}

