/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockLoad;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerArray;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.SpecFlag;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;
import java.util.AbstractList;

public class SpecFlagsArray
extends IntegerArray
implements BlockLoad,
JSONConvert<JSONArray> {
    private final IntegerItem entryCount;
    private AbstractList<SpecFlag> specFlagList;

    public SpecFlagsArray(IntegerItem entryCount) {
        this.entryCount = entryCount;
        this.entryCount.setBlockLoad(this);
        this.setBlockLoad(this);
    }

    public AbstractList<SpecFlag> listSpecFlags() {
        if (this.specFlagList == null) {
            this.specFlagList = new AbstractList<SpecFlag>(){

                @Override
                public SpecFlag get(int i) {
                    return SpecFlagsArray.this.getFlag(i);
                }

                @Override
                public int size() {
                    return SpecFlagsArray.this.size();
                }
            };
        }
        return this.specFlagList;
    }

    public SpecFlag getFlag(int id) {
        if ((id &= 0xFFFF) >= this.size()) {
            return null;
        }
        int offset = id * 4;
        return new SpecFlag(this, offset);
    }

    public void set(int entryId, int value) {
        this.setFlag(entryId, value);
        this.refresh();
    }

    private void setFlag(int id, int flag) {
        id = 0xFFFF & id;
        this.ensureArraySize(id + 1);
        super.put(id, flag);
    }

    @Override
    public Integer get(int entryId) {
        entryId = 0xFFFF & entryId;
        return super.get(entryId);
    }

    @Override
    public void onBlockLoaded(BlockReader reader, Block sender) throws IOException {
        if (sender == this.entryCount) {
            super.setSize(this.entryCount.get());
        }
    }

    public void refresh() {
        this.entryCount.set(this.size());
    }

    public void merge(SpecFlagsArray specFlagsArray) {
        if (specFlagsArray == null || specFlagsArray == this) {
            return;
        }
        this.ensureArraySize(specFlagsArray.size());
        int[] comingValues = specFlagsArray.toArray();
        int[] existValues = this.toArray();
        for (int i = 0; i < comingValues.length; ++i) {
            int valueComing = comingValues[i];
            if (valueComing == 0) continue;
            int value = existValues[i] | valueComing;
            this.put(i, value);
        }
        this.refresh();
    }

    @Override
    public JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        int[] flagValues = this.toArray();
        for (int i = 0; i < flagValues.length; ++i) {
            int value = flagValues[i];
            if (value == 0) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", i);
            jsonObject.put("flag", value);
            jsonArray.put(jsonObject);
        }
        if (jsonArray.length() == 0) {
            return null;
        }
        return jsonArray;
    }

    @Override
    public void fromJson(JSONArray json) {
        if (json == null || json.length() == 0) {
            this.setSize(0);
            this.refresh();
            return;
        }
        int length = json.length();
        this.flagFromJson(json.getJSONObject(--length));
        for (int i = 0; i < length; ++i) {
            this.flagFromJson(json.getJSONObject(i));
        }
        this.refresh();
    }

    private void flagFromJson(JSONObject jsonObject) {
        int id = jsonObject.getInt("id");
        int flag = jsonObject.getInt("flag");
        this.setFlag(id, flag);
    }
}

