/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.chunk.SpecBlock;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.item.IndirectItem;
import com.reandroid.arsc.item.SpecFlagsArray;
import com.reandroid.arsc.util.HexUtil;

public class SpecFlag
extends IndirectItem<SpecFlagsArray> {
    private static final int OFFSET_FLAG = 3;

    public SpecFlag(SpecFlagsArray specFlagsArray, int offset) {
        super(specFlagsArray, offset);
    }

    public byte getFlagByte() {
        return ((SpecFlagsArray)this.getBlockItem()).getBytesInternal()[this.getOffset() + 3];
    }

    public void setFlagByte(byte flag) {
        ((SpecFlagsArray)this.getBlockItem()).getBytesInternal()[this.getOffset() + 3] = flag;
    }

    public void addFlagByte(byte flag) {
        flag = (byte)(this.getFlagByte() & 0xFF | flag & 0xFF);
        this.setFlagByte(flag);
    }

    public void addFlag(SpecBlock.Flag flag) {
        this.addFlagByte(flag.getFlag());
    }

    public void setPublic() {
        this.addFlag(SpecBlock.Flag.SPEC_PUBLIC);
    }

    public boolean isPublic() {
        return SpecBlock.Flag.isPublic(this.getFlagByte());
    }

    public int getInteger() {
        return BlockItem.getInteger(((SpecFlagsArray)this.getBlockItem()).getBytesInternal(), this.getOffset());
    }

    public void setInteger(int value) {
        if (value == this.getInteger()) {
            return;
        }
        BlockItem.putInteger(((SpecFlagsArray)this.getBlockItem()).getBytesInternal(), this.getOffset(), value);
        ((SpecFlagsArray)this.getBlockItem()).onBytesChanged();
    }

    public String toString() {
        byte flag = this.getFlagByte();
        if (flag != 0) {
            return SpecBlock.Flag.toString(this.getFlagByte());
        }
        int val = this.getInteger();
        if (val != 0) {
            return HexUtil.toHex8(val);
        }
        return "";
    }
}

