/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.arsc.util.HexUtil;
import java.io.IOException;
import java.io.InputStream;

public class ShortItem
extends BlockItem {
    private short mCache;

    public ShortItem() {
        super(2);
    }

    public ShortItem(short val) {
        this();
        this.set(val);
    }

    public void set(short val) {
        if (val == this.mCache) {
            return;
        }
        this.mCache = val;
        byte[] bts = this.getBytesInternal();
        bts[1] = (byte)(val >>> 8 & 0xFF);
        bts[0] = (byte)(val & 0xFF);
    }

    public short get() {
        return this.mCache;
    }

    public int unsignedInt() {
        return 0xFFFF & this.get();
    }

    public String toHex() {
        return HexUtil.toHex4(this.get());
    }

    @Override
    protected void onBytesChanged() {
        this.mCache = this.readShortBytes();
    }

    private short readShortBytes() {
        byte[] bts = this.getBytesInternal();
        return (short)(bts[0] & 0xFF | (bts[1] & 0xFF) << 8);
    }

    public String toString() {
        return String.valueOf(this.get());
    }

    public static short readShort(BlockReader reader) throws IOException {
        ShortItem shortItem = new ShortItem();
        shortItem.readBytes(reader);
        return shortItem.get();
    }

    public static short readShort(InputStream inputStream) throws IOException {
        ShortItem shortItem = new ShortItem();
        shortItem.readBytes(inputStream);
        return shortItem.get();
    }

    public static int readUnsignedShort(BlockReader reader) throws IOException {
        return 0xFFFF & ShortItem.readShort(reader);
    }

    public static int readUnsignedShort(InputStream inputStream) throws IOException {
        return 0xFFFF & ShortItem.readShort(inputStream);
    }
}

