/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.chunk.xml.ResXmlDocument;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.ReferenceItem;
import com.reandroid.arsc.item.ResXmlString;
import com.reandroid.arsc.pool.ResXmlStringPool;
import com.reandroid.arsc.util.HexUtil;
import java.util.ArrayList;
import java.util.List;

public class ResXmlID
extends IntegerItem {
    private final List<ReferenceItem> mReferencedList = new ArrayList<ReferenceItem>();

    public ResXmlID(int resId) {
        super(resId);
    }

    public ResXmlID() {
        this(0);
    }

    public boolean removeReference(ReferenceItem ref) {
        return this.mReferencedList.remove(ref);
    }

    public List<ReferenceItem> getReferencedList() {
        return this.mReferencedList;
    }

    public void addReference(ReferenceItem ref) {
        if (ref != null) {
            this.mReferencedList.add(ref);
        }
    }

    public boolean hasReference() {
        return this.mReferencedList.size() > 0;
    }

    public int getReferenceCount() {
        return this.mReferencedList.size();
    }

    private void reUpdateReferences(int newIndex) {
        for (ReferenceItem ref : this.mReferencedList) {
            ref.set(newIndex);
        }
    }

    @Override
    public void onIndexChanged(int oldIndex, int newIndex) {
    }

    public String getName() {
        ResXmlString xmlString = this.getResXmlString();
        if (xmlString == null) {
            return null;
        }
        return xmlString.getHtml();
    }

    public ResXmlString getResXmlString() {
        ResXmlStringPool stringPool = this.getXmlStringPool();
        if (stringPool == null) {
            return null;
        }
        return (ResXmlString)stringPool.get(this.getIndex());
    }

    private ResXmlStringPool getXmlStringPool() {
        ResXmlDocument resXmlDocument = this.getParentInstance(ResXmlDocument.class);
        if (resXmlDocument != null) {
            return resXmlDocument.getStringPool();
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("USED-BY=");
        builder.append(this.getReferenceCount());
        builder.append('{');
        String name = this.getName();
        if (name != null) {
            builder.append(name);
        } else {
            builder.append(this.getIndex());
        }
        builder.append(':');
        builder.append(HexUtil.toHex8(this.get()));
        builder.append('}');
        return builder.toString();
    }
}

