/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.arsc.item;

import com.reandroid.arsc.item.BlockItem;
import java.util.AbstractList;
import java.util.List;

public class IntegerArray
extends BlockItem {
    public IntegerArray() {
        super(0);
    }

    public final boolean contains(int value) {
        int s = this.size();
        for (int i = 0; i < s; ++i) {
            if (value != this.get(i)) continue;
            return true;
        }
        return false;
    }

    public final void clear() {
        this.setSize(0);
    }

    public final void add(int value) {
        int old = this.size();
        this.setSize(old + 1);
        this.put(old, value);
    }

    public final void add(int[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        int old = this.size();
        int s = old + values.length;
        this.setSize(s);
        for (int i = 0; i < s; ++i) {
            this.put(old + i, values[i]);
        }
    }

    public final void set(int[] values) {
        if (values == null || values.length == 0) {
            this.setSize(0);
            return;
        }
        int s = values.length;
        this.setSize(s);
        for (int i = 0; i < s; ++i) {
            this.put(i, values[i]);
        }
    }

    public final List<Integer> toList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int i) {
                return IntegerArray.this.get(i);
            }

            @Override
            public int size() {
                return IntegerArray.this.size();
            }
        };
    }

    public final int[] toArray() {
        int s = this.size();
        int[] result = new int[s];
        for (int i = 0; i < s; ++i) {
            result[i] = this.get(i);
        }
        return result;
    }

    public final void fill(int value) {
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            this.put(i, value);
        }
    }

    public final void ensureArraySize(int s) {
        int sz = this.size();
        if (sz >= s) {
            return;
        }
        this.setSize(s);
    }

    public final void setSize(int s) {
        if (s < 0) {
            s = 0;
        }
        int len = s * 4;
        this.setBytesLength(len);
    }

    public Integer get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        int i = index * 4;
        byte[] bts = this.getBytesInternal();
        return bts[i] & 0xFF | (bts[i + 1] & 0xFF) << 8 | (bts[i + 2] & 0xFF) << 16 | (bts[i + 3] & 0xFF) << 24;
    }

    public int getAt(int index) {
        int i = index * 4;
        byte[] bts = this.getBytesInternal();
        return bts[i] & 0xFF | (bts[i + 1] & 0xFF) << 8 | (bts[i + 2] & 0xFF) << 16 | (bts[i + 3] & 0xFF) << 24;
    }

    public final int size() {
        return this.getBytesLength() / 4;
    }

    public final void put(int index, int value) {
        int i = index * 4;
        byte[] bts = this.getBytesInternal();
        bts[i + 3] = (byte)(value >>> 24 & 0xFF);
        bts[i + 2] = (byte)(value >>> 16 & 0xFF);
        bts[i + 1] = (byte)(value >>> 8 & 0xFF);
        bts[i] = (byte)(value & 0xFF);
    }

    public String toString() {
        return "size=" + this.size();
    }
}

